/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.drivers;

import org.apache.mahout.common.HDFSPathSearch;
import org.apache.mahout.drivers.MahoutSparkDriver;
import org.apache.mahout.drivers.MahoutSparkOptionParser;
import org.apache.mahout.drivers.RowSimilarityDriver$;
import org.apache.mahout.math.cf.SimilarityAnalysis$;
import org.apache.mahout.math.indexeddataset.IndexedDataset;
import org.apache.mahout.math.indexeddataset.Schema;
import org.apache.mahout.math.indexeddataset.package$;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scopt.Read$;

public final class RowSimilarityDriver$
extends MahoutSparkDriver {
    public static final RowSimilarityDriver$ MODULE$;
    private final HashMap<String, Object> org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions;
    private Schema readWriteSchema;

    static {
        new RowSimilarityDriver$();
    }

    public final HashMap<String, Object> org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions() {
        return this.org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions;
    }

    private Schema readWriteSchema() {
        return this.readWriteSchema;
    }

    private void readWriteSchema_$eq(Schema x$1) {
        this.readWriteSchema = x$1;
    }

    public void main(String[] args) {
        this.parser_$eq(new MahoutSparkOptionParser(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-rowsimilarity", "Mahout"}));
                this.parseIOOptions(this.parseIOOptions$default$1());
                this.opts_$eq(this.opts().$plus$plus(RowSimilarityDriver$.MODULE$.org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions()));
                this.note("\nAlgorithm control options:");
                this.opt("maxObservations", Read$.MODULE$.intRead()).abbr("mo").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(int x, Map<String, Object> options) {
                        return options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxObservations"), (Object)BoxesRunTime.boxToInteger((int)x)));
                    }
                }).text(new StringBuilder().append((Object)"Max number of observations to consider per row (optional). Default: ").append(RowSimilarityDriver$.MODULE$.org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions().apply((Object)"maxObservations")).toString()).validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(int x) {
                        return x > 0 ? this.$outer.success() : this.$outer.failure("Option --maxObservations must be > 0");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.opt('m', "maxSimilaritiesPerRow", Read$.MODULE$.intRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(int x, Map<String, Object> options) {
                        return options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxSimilaritiesPerRow"), (Object)BoxesRunTime.boxToInteger((int)x)));
                    }
                }).text(new StringBuilder().append((Object)"Limit the number of similarities per item to this number (optional). Default: ").append(RowSimilarityDriver$.MODULE$.org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions().apply((Object)"maxSimilaritiesPerRow")).toString()).validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(int x) {
                        return x > 0 ? this.$outer.success() : this.$outer.failure("Option --maxSimilaritiesPerRow must be > 0");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.note("\nNote: Only the Log Likelihood Ratio (LLR) is supported as a similarity measure.");
                this.parseIndexedDatasetFormatOptions("\nInput and Output text file schema options (same for both):");
                this.parseFileDiscoveryOptions();
                this.parseSparkOptions(RowSimilarityDriver$.MODULE$.sparkConf());
                this.parseGenericOptions();
                this.help("help").abbr("h").text("prints this usage text\n");
            }
        });
        this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)this.parser().opts()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Map<String, Object> opts) {
                RowSimilarityDriver$.MODULE$.parser().opts_$eq(opts);
                RowSimilarityDriver$.MODULE$.process();
            }
        });
    }

    @Override
    public void start() {
        super.start();
        this.readWriteSchema_$eq(new Schema((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKeyDelim"), (Object)((String)this.parser().opts().apply((Object)"rowKeyDelim"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"columnIdStrengthDelim"), (Object)((String)this.parser().opts().apply((Object)"columnIdStrengthDelim"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"omitScore"), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"omitStrength")))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"elementDelim"), (Object)((String)this.parser().opts().apply((Object)"elementDelim")))})));
    }

    /*
     * WARNING - void declaration
     */
    private IndexedDataset readIndexedDataset() {
        IndexedDataset indexedDataset;
        String inFiles = new HDFSPathSearch((String)this.parser().opts().apply((Object)"input"), (String)this.parser().opts().apply((Object)"filenamePattern"), BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"recursive"))).uris();
        if (inFiles.isEmpty()) {
            indexedDataset = null;
        } else {
            void var2_2;
            IndexedDataset datasetA = package$.MODULE$.indexedDatasetDFSRead(inFiles, this.readWriteSchema(), package$.MODULE$.indexedDatasetDFSRead$default$3(), this.mc());
            indexedDataset = var2_2;
        }
        return indexedDataset;
    }

    public void process() {
        this.start();
        IndexedDataset indexedDataset = this.readIndexedDataset();
        IndexedDataset rowSimilarityIDS = SimilarityAnalysis$.MODULE$.rowSimilarityIDS(indexedDataset, BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"randomSeed")), BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"maxSimilaritiesPerRow")), BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"maxObservations")));
        rowSimilarityIDS.dfsWrite((String)this.parser().opts().apply((Object)"output"), this.readWriteSchema(), this.mc());
        this.stop();
    }

    private RowSimilarityDriver$() {
        MODULE$ = this;
        this.org$apache$mahout$drivers$RowSimilarityDriver$$RowSimilarityOptions = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxObservations"), (Object)BoxesRunTime.boxToInteger((int)500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxSimilaritiesPerRow"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"appName"), (Object)"RowSimilarityDriver")}));
    }
}

