/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.function.LongShortProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.AbstractLongShortMap;
import org.apache.mahout.math.map.HashFunctions;

public class OpenLongShortHashMap
extends AbstractLongShortMap {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final long NO_KEY_VALUE = 0L;
    protected long[] table;
    protected short[] values;
    protected byte[] state;
    protected int freeEntries;

    public OpenLongShortHashMap() {
        this(277);
    }

    public OpenLongShortHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenLongShortHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenLongShortHashMap copy = (OpenLongShortHashMap)super.clone();
        copy.table = (long[])copy.table.clone();
        copy.values = (short[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean containsKey(long key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(short value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    @Override
    public boolean forEachKey(LongProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachPair(LongShortProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public short get(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(long key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && this.table[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(long key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(short value) {
        short[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void keys(LongArrayList list) {
        list.setSize(this.distinct);
        long[] elements = list.elements();
        int j = 0;
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.table[i];
        }
    }

    public Iterator<MapElement> iterator() {
        return new MapIterator();
    }

    @Override
    public void pairsMatching(LongShortProcedure condition, LongArrayList keyList, ShortArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    @Override
    public boolean put(long key, short value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    public short adjustOrPutValue(long key, short newValue, short incrValue) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            int n = i = -i - 1;
            this.values[n] = (short)(this.values[n] + incrValue);
            return this.values[i];
        }
        this.put(key, newValue);
        return newValue;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        long[] oldTable = this.table;
        short[] oldValues = this.values;
        byte[] oldState = this.state;
        this.table = new long[newCapacity];
        this.values = new short[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            long element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.values[index] = oldValues[i];
            this.state[index] = 1;
        }
    }

    @Override
    public boolean removeKey(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new long[capacity];
        this.values = new short[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    @Override
    public void values(ShortArrayList list) {
        list.setSize(this.distinct);
        short[] elements = list.elements();
        int j = 0;
        int i = this.state.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.values[i];
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }

    public final class MapIterator
    implements Iterator<MapElement> {
        private final MapElement element;

        private MapIterator() {
            this.element = new MapElement();
        }

        @Override
        public boolean hasNext() {
            return this.element.seen < OpenLongShortHashMap.this.distinct;
        }

        @Override
        public MapElement next() {
            if (this.element.advanceOffset()) {
                return this.element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public final class MapElement {
        private int offset = -1;
        int seen = 0;

        boolean advanceOffset() {
            ++this.offset;
            while (this.offset < OpenLongShortHashMap.this.state.length && OpenLongShortHashMap.this.state[this.offset] != 1) {
                ++this.offset;
            }
            if (this.offset < OpenLongShortHashMap.this.state.length) {
                ++this.seen;
            }
            return this.offset < OpenLongShortHashMap.this.state.length;
        }

        public short get() {
            return OpenLongShortHashMap.this.values[this.offset];
        }

        public long index() {
            return OpenLongShortHashMap.this.table[this.offset];
        }

        public void set(short value) {
            OpenLongShortHashMap.this.values[this.offset] = value;
        }
    }
}

