/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class FacetsPayloadMigrationReader
extends FilterAtomicReader {
    public static final String PAYLOAD_TERM_TEXT = "$fulltree$";
    private final Map<String, Term> fieldTerms;

    public static Map<String, Term> buildFieldTermsMap(Directory dir, FacetIndexingParams fip) throws IOException {
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        HashMap<String, Term> fieldTerms = new HashMap<String, Term>();
        for (AtomicReaderContext context : reader.leaves()) {
            for (CategoryListParams clp : fip.getAllCategoryListParams()) {
                Terms terms = context.reader().terms(clp.field);
                if (terms == null) continue;
                TermsEnum te = terms.iterator(null);
                BytesRef termBytes = null;
                while ((termBytes = te.next()) != null) {
                    String term = termBytes.utf8ToString();
                    if (!term.startsWith(PAYLOAD_TERM_TEXT)) continue;
                    if (term.equals(PAYLOAD_TERM_TEXT)) {
                        fieldTerms.put(clp.field, new Term(clp.field, term));
                        continue;
                    }
                    fieldTerms.put(clp.field + term.substring(PAYLOAD_TERM_TEXT.length()), new Term(clp.field, term));
                }
            }
        }
        reader.close();
        return fieldTerms;
    }

    public FacetsPayloadMigrationReader(AtomicReader in, Map<String, Term> fieldTerms) {
        super(in);
        this.fieldTerms = fieldTerms;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        Term term = this.fieldTerms.get(field);
        if (term == null) {
            return super.getBinaryDocValues(field);
        }
        return new PayloadMigratingBinaryDocValues(this.fields(), term);
    }

    public Bits getDocsWithField(String field) throws IOException {
        Term term = this.fieldTerms.get(field);
        if (term == null) {
            return super.getDocsWithField(field);
        }
        return new Bits.MatchAllBits(this.maxDoc());
    }

    public FieldInfos getFieldInfos() {
        FieldInfos innerInfos = super.getFieldInfos();
        ArrayList<FieldInfo> infos = new ArrayList<FieldInfo>(innerInfos.size());
        HashSet<String> leftoverFields = new HashSet<String>(this.fieldTerms.keySet());
        int number = -1;
        for (FieldInfo info : innerInfos) {
            if (this.fieldTerms.containsKey(info.name)) {
                infos.add(new FieldInfo(info.name, true, info.number, info.hasVectors(), info.omitsNorms(), info.hasPayloads(), info.getIndexOptions(), FieldInfo.DocValuesType.BINARY, info.getNormType(), info.attributes()));
                leftoverFields.remove(info.name);
            } else {
                infos.add(info);
            }
            number = Math.max(number, info.number);
        }
        for (String field : leftoverFields) {
            infos.add(new FieldInfo(field, false, ++number, false, false, false, null, FieldInfo.DocValuesType.BINARY, null, null));
        }
        return new FieldInfos(infos.toArray(new FieldInfo[infos.size()]));
    }

    private class PayloadMigratingBinaryDocValues
    extends BinaryDocValues {
        private Fields fields;
        private Term term;
        private DocsAndPositionsEnum dpe;
        private int curDocID = -1;
        private int lastRequestedDocID;

        private DocsAndPositionsEnum getDPE() {
            try {
                TermsEnum te;
                Terms terms;
                DocsAndPositionsEnum dpe = null;
                if (this.fields != null && (terms = this.fields.terms(this.term.field())) != null && (te = terms.iterator(null)).seekExact(this.term.bytes())) {
                    dpe = te.docsAndPositions(null, null, 2);
                }
                return dpe;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        protected PayloadMigratingBinaryDocValues(Fields fields, Term term) {
            this.fields = fields;
            this.term = term;
            this.dpe = this.getDPE();
            if (this.dpe == null) {
                this.curDocID = Integer.MAX_VALUE;
            } else {
                try {
                    this.curDocID = this.dpe.nextDoc();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void get(int docID, BytesRef result) {
            try {
                if (docID <= this.lastRequestedDocID) {
                    this.dpe = this.getDPE();
                    this.curDocID = this.dpe == null ? Integer.MAX_VALUE : this.dpe.nextDoc();
                }
                this.lastRequestedDocID = docID;
                if (this.curDocID > docID) {
                    result.length = 0;
                    return;
                }
                if (this.curDocID < docID) {
                    this.curDocID = this.dpe.advance(docID);
                    if (this.curDocID != docID) {
                        result.length = 0;
                        return;
                    }
                }
                this.dpe.nextPosition();
                result.copyBytes(this.dpe.getPayload());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

