/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache.cl2o;

import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CharBlockArray;

class CategoryPathUtils {
    CategoryPathUtils() {
    }

    public static void serialize(CategoryPath cp, CharBlockArray charBlockArray) {
        charBlockArray.append((char)cp.length);
        if (cp.length == 0) {
            return;
        }
        for (int i = 0; i < cp.length; ++i) {
            charBlockArray.append((char)cp.components[i].length());
            charBlockArray.append(cp.components[i]);
        }
    }

    public static int hashCodeOfSerialized(CharBlockArray charBlockArray, int offset) {
        int length;
        if ((length = (int)charBlockArray.charAt(offset++)) == 0) {
            return 0;
        }
        int hash = length;
        for (int i = 0; i < length; ++i) {
            short len = (short)charBlockArray.charAt(offset++);
            hash = hash * 31 + charBlockArray.subSequence(offset, offset + len).hashCode();
            offset += len;
        }
        return hash;
    }

    public static boolean equalsToSerialized(CategoryPath cp, CharBlockArray charBlockArray, int offset) {
        char n;
        if (cp.length != (n = charBlockArray.charAt(offset++))) {
            return false;
        }
        if (cp.length == 0) {
            return true;
        }
        for (int i = 0; i < cp.length; ++i) {
            short len;
            if ((len = (short)charBlockArray.charAt(offset++)) != cp.components[i].length()) {
                return false;
            }
            if (!cp.components[i].equals(charBlockArray.subSequence(offset, offset + len))) {
                return false;
            }
            offset += len;
        }
        return true;
    }
}

