/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.params;

import java.io.IOException;
import org.apache.lucene.facet.encoding.DGapVInt8IntEncoder;
import org.apache.lucene.facet.encoding.IntEncoder;
import org.apache.lucene.facet.encoding.SortingIntEncoder;
import org.apache.lucene.facet.encoding.UniqueValuesIntEncoder;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.DocValuesCategoryListIterator;
import org.apache.lucene.facet.util.PartitionsUtils;

public class CategoryListParams {
    public static final String DEFAULT_FIELD = "$facets";
    public static final OrdinalPolicy DEFAULT_ORDINAL_POLICY = OrdinalPolicy.ALL_BUT_DIMENSION;
    public final String field;
    private final int hashCode;

    public CategoryListParams() {
        this(DEFAULT_FIELD);
    }

    public CategoryListParams(String field) {
        this.field = field;
        this.hashCode = field.hashCode();
    }

    public IntEncoder createEncoder() {
        return new SortingIntEncoder(new UniqueValuesIntEncoder(new DGapVInt8IntEncoder()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryListParams)) {
            return false;
        }
        CategoryListParams other = (CategoryListParams)o;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return this.field.equals(other.field);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public CategoryListIterator createCategoryListIterator(int partition) throws IOException {
        String categoryListTermStr = PartitionsUtils.partitionName(partition);
        String docValuesField = this.field + categoryListTermStr;
        return new DocValuesCategoryListIterator(docValuesField, this.createEncoder().createMatchingDecoder());
    }

    public OrdinalPolicy getOrdinalPolicy(String dimension) {
        return DEFAULT_ORDINAL_POLICY;
    }

    public String toString() {
        return "field=" + this.field + " encoder=" + this.createEncoder() + " ordinalPolicy=" + (Object)((Object)this.getOrdinalPolicy(null));
    }

    public static enum OrdinalPolicy {
        NO_PARENTS,
        ALL_PARENTS,
        ALL_BUT_DIMENSION;

    }
}

