/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings.ops;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.mahout.h2obindings.H2OBlockMatrix;
import org.apache.mahout.h2obindings.drm.H2ODrm;
import org.apache.mahout.h2obindings.ops.MapBlockHelper;
import org.apache.mahout.math.Matrix;
import scala.reflect.ClassTag;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class MapBlock {
    public static <K, R> H2ODrm exec(H2ODrm drmA, int ncol, Object bmf, final boolean isRstr, final ClassTag<K> k, final ClassTag<R> r) {
        Frame A = drmA.frame;
        Vec keys = drmA.keys;
        int ncolRes = ncol + (isRstr ? 1 : 0);
        class MRTaskBMF
        extends MRTask<MRTaskBMF> {
            Serializable bmf;
            Vec labels;

            MRTaskBMF(Object _bmf, Vec _labels) {
                this.bmf = (Serializable)_bmf;
                this.labels = _labels;
            }

            private Matrix blockify(Chunk[] chks) {
                return new H2OBlockMatrix(chks);
            }

            private void deblockify(Matrix out, NewChunk[] ncs) {
                for (int c = 0; c < out.columnSize(); ++c) {
                    for (int r2 = 0; r2 < out.rowSize(); ++r2) {
                        ncs[c].addNum(out.getQuick(r2, c));
                    }
                }
            }

            public void map(Chunk[] chks, NewChunk[] ncs) {
                long start = chks[0].start();
                NewChunk nclabel = isRstr ? ncs[ncs.length - 1] : null;
                this.deblockify(MapBlockHelper.exec(this.bmf, this.blockify(chks), start, this.labels, nclabel, k, r), ncs);
            }
        }
        Frame fmap = ((MRTaskBMF)new MRTaskBMF(bmf, keys).doAll(ncolRes, A)).outputFrame(null, null);
        Vec vmap = null;
        if (isRstr) {
            vmap = fmap.vecs()[ncol];
            fmap = new Frame(Arrays.copyOfRange(fmap.vecs(), 0, ncol));
        }
        return new H2ODrm(fmap, vmap);
    }
}

