/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings.ops;

import org.apache.mahout.h2obindings.drm.H2ODrm;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class Cbind {
    public static H2ODrm exec(H2ODrm drmA, H2ODrm drmB) {
        Frame fra = drmA.frame;
        Vec keysa = drmA.keys;
        Frame frb = drmB.frame;
        Vec keysb = drmB.keys;
        if (fra.anyVec().group() == frb.anyVec().group()) {
            return Cbind.zip(fra, keysa, frb, keysb);
        }
        return Cbind.join(fra, keysa, frb, keysb);
    }

    private static H2ODrm zip(Frame fra, Vec keysa, Frame frb, Vec keysb) {
        Vec[] vecs = new Vec[fra.vecs().length + frb.vecs().length];
        int d = 0;
        for (Vec vfra : fra.vecs()) {
            vecs[d++] = vfra;
        }
        for (Vec vfrb : frb.vecs()) {
            vecs[d++] = vfrb;
        }
        Frame fr = new Frame(vecs);
        return new H2ODrm(fr, keysa);
    }

    private static H2ODrm join(Frame fra, Vec keysa, final Frame frb, Vec keysb) {
        Vec[] bvecs = new Vec[frb.vecs().length];
        for (int i = 0; i < bvecs.length; ++i) {
            bvecs[i] = fra.anyVec().makeZero();
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                int chunkSize = chks[0].len();
                long start = chks[0].start();
                Vec[] vecs = frb.vecs();
                for (int r = 0; r < chunkSize; ++r) {
                    for (int c = 0; c < chks.length; ++c) {
                        chks[c].set(r, vecs[c].at(start + (long)r));
                    }
                }
            }
        }.doAll(bvecs);
        return Cbind.zip(fra, keysa, new Frame(bvecs), null);
    }
}

