/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings.ops;

import java.io.Serializable;
import org.apache.mahout.h2obindings.drm.H2ODrm;
import scala.Function1;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class AewUnary {
    public static H2ODrm exec(H2ODrm drmA, Object f, final boolean evalZeros) {
        Frame A = drmA.frame;
        Vec keys = drmA.keys;
        int ncol = A.numCols();
        class MRTaskAewUnary
        extends MRTask<MRTaskAewUnary> {
            Serializable fn;

            MRTaskAewUnary(Object _fn) {
                this.fn = (Serializable)_fn;
            }

            public void map(Chunk[] chks, NewChunk[] ncs) {
                for (int c = 0; c < chks.length; ++c) {
                    Chunk chk = chks[c];
                    Function1 f = (Function1)this.fn;
                    int ChunkLen = chk.len();
                    if (!evalZeros && chk.isSparse()) {
                        int prev_offset = -1;
                        int r = chk.nextNZ(-1);
                        while (r < ChunkLen) {
                            if (r - prev_offset > 1) {
                                ncs[c].addZeros(r - prev_offset - 1);
                            }
                            ncs[c].addNum(((Double)f.apply((Object)chk.atd(r))).doubleValue());
                            prev_offset = r;
                            r = chk.nextNZ(prev_offset);
                        }
                        if (ChunkLen - prev_offset <= 1) continue;
                        ncs[c].addZeros(chk._len - prev_offset - 1);
                        continue;
                    }
                    for (int r = 0; r < ChunkLen; ++r) {
                        ncs[c].addNum(((Double)f.apply((Object)chk.atd(r))).doubleValue());
                    }
                }
            }
        }
        Frame fmap = ((MRTaskAewUnary)new MRTaskAewUnary(f).doAll(ncol, A)).outputFrame(null, null);
        return new H2ODrm(fmap, keys);
    }
}

