/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.mahout.h2obindings.H2OBlockMatrix;
import org.apache.mahout.h2obindings.drm.H2OBCast;
import org.apache.mahout.h2obindings.drm.H2ODrm;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.ValueString;
import water.util.ArrayUtils;

public class H2OHelper {
    public static boolean isSparse(Frame frame) {
        long sparselen;
        long cols;
        long rows = frame.numRows();
        class MRTaskNZ
        extends MRTask<MRTaskNZ> {
            long sparselen;

            MRTaskNZ() {
            }

            public void map(Chunk[] chks) {
                for (Chunk chk : chks) {
                    this.sparselen += (long)chk.sparseLen();
                }
            }

            public void reduce(MRTaskNZ other) {
                this.sparselen += other.sparselen;
            }
        }
        return rows * (cols = (long)frame.numCols()) / ((sparselen = ((MRTaskNZ)new MRTaskNZ().doAll((Frame)frame)).sparselen) + 1L) > 32L;
    }

    public static Matrix matrixFromDrm(H2ODrm drm) {
        Frame frame = drm.frame;
        Vec labels = drm.keys;
        Object m = H2OHelper.isSparse(frame) ? new SparseMatrix((int)frame.numRows(), frame.numCols()) : new DenseMatrix((int)frame.numRows(), frame.numCols());
        int c = 0;
        for (Vec v : frame.vecs()) {
            int r = 0;
            while ((long)r < frame.numRows()) {
                double d;
                if (!v.isNA((long)r) && (d = v.at((long)r)) != 0.0) {
                    m.setQuick(r, c, d);
                }
                ++r;
            }
            ++c;
        }
        if (labels != null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            ValueString vstr = new ValueString();
            for (long i = 0L; i < labels.length(); ++i) {
                map.put(labels.atStr(vstr, i).toString(), (int)i);
            }
            m.setRowLabelBindings(map);
        }
        return m;
    }

    public static Vector colMeans(Frame frame) {
        double[] means = new double[frame.numCols()];
        for (int i = 0; i < frame.numCols(); ++i) {
            means[i] = frame.vecs()[i].mean();
        }
        return new DenseVector(means);
    }

    public static Vector colSums(Frame frame) {
        class MRTaskSum
        extends MRTask<MRTaskSum> {
            public double[] sums;

            MRTaskSum() {
            }

            public void map(Chunk[] chks) {
                this.sums = new double[chks.length];
                for (int c = 0; c < chks.length; ++c) {
                    for (int r = 0; r < chks[c].len(); ++r) {
                        int n = c;
                        this.sums[n] = this.sums[n] + chks[c].atd(r);
                    }
                }
            }

            public void reduce(MRTaskSum other) {
                ArrayUtils.add((double[])this.sums, (double[])other.sums);
            }
        }
        return new DenseVector(((MRTaskSum)new MRTaskSum().doAll((Frame)frame)).sums);
    }

    public static double sumSqr(Frame frame) {
        class MRTaskSumSqr
        extends MRTask<MRTaskSumSqr> {
            public double sumSqr;

            MRTaskSumSqr() {
            }

            public void map(Chunk[] chks) {
                for (Chunk chk : chks) {
                    for (int r = 0; r < chk.len(); ++r) {
                        this.sumSqr += chk.atd(r) * chk.atd(r);
                    }
                }
            }

            public void reduce(MRTaskSumSqr other) {
                this.sumSqr += other.sumSqr;
            }
        }
        return ((MRTaskSumSqr)new MRTaskSumSqr().doAll((Frame)frame)).sumSqr;
    }

    public static Vector nonZeroCnt(Frame frame) {
        class MRTaskNonZero
        extends MRTask<MRTaskNonZero> {
            public double[] sums;

            MRTaskNonZero() {
            }

            public void map(Chunk[] chks) {
                this.sums = new double[chks.length];
                for (int c = 0; c < chks.length; ++c) {
                    for (int r = 0; r < chks[c].len(); ++r) {
                        if ((long)chks[c].atd(r) == 0L) continue;
                        int n = c;
                        this.sums[n] = this.sums[n] + 1.0;
                    }
                }
            }

            public void reduce(MRTaskNonZero other) {
                ArrayUtils.add((double[])this.sums, (double[])other.sums);
            }
        }
        return new DenseVector(((MRTaskNonZero)new MRTaskNonZero().doAll((Frame)frame)).sums);
    }

    private static Map<Integer, String> reverseMap(Map<String, Integer> map) {
        if (map == null) {
            return null;
        }
        HashMap<Integer, String> rmap = new HashMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            rmap.put(entry.getValue(), entry.getKey());
        }
        return rmap;
    }

    private static int chunkSize(long nrow, int minHint, int exactHint) {
        int partsHint = Math.max(minHint, exactHint);
        if (partsHint < 1) {
            partsHint = 4;
        }
        int chunkSz = (int)((nrow - 1L) / (long)partsHint + 1L);
        if (exactHint > 0) {
            return chunkSz;
        }
        if ((double)chunkSz > 1000000.0) {
            chunkSz = 1000000;
        }
        if (minHint > 0) {
            return chunkSz;
        }
        if ((double)chunkSz < 1000.0) {
            chunkSz = 1000;
        }
        return chunkSz;
    }

    public static H2ODrm drmFromMatrix(Matrix m, int minHint, int exactHint) {
        Frame frame = H2OHelper.emptyFrame(m.rowSize(), m.columnSize(), minHint, exactHint);
        Vec labels = null;
        Vec.Writer[] writers = new Vec.Writer[m.columnSize()];
        Futures closer = new Futures();
        for (int i = 0; i < writers.length; ++i) {
            writers[i] = frame.vecs()[i].open();
        }
        for (int r = 0; r < m.rowSize(); ++r) {
            for (int c = 0; c < m.columnSize(); ++c) {
                writers[c].set((long)r, m.getQuick(r, c));
            }
        }
        for (int c = 0; c < m.columnSize(); ++c) {
            writers[c].close(closer);
        }
        Map map = m.getRowLabelBindings();
        if (map != null) {
            labels = H2OHelper.makeEmptyStrVec(frame.anyVec());
            Vec.Writer writer = labels.open();
            Map<Integer, String> rmap = H2OHelper.reverseMap(map);
            for (int r = 0; r < m.rowSize(); ++r) {
                writer.set((long)r, rmap.get(r));
            }
            writer.close(closer);
        }
        closer.blockForPending();
        return new H2ODrm(frame, labels);
    }

    public static Frame emptyFrame(long nrow, int ncol, int minHint, int exactHint) {
        Vec.VectorGroup vg = new Vec.VectorGroup();
        return H2OHelper.emptyFrame(nrow, ncol, minHint, exactHint, vg);
    }

    public static Frame emptyFrame(long nrow, int ncol, int minHint, int exactHint, Vec.VectorGroup vg) {
        int chunkSz = H2OHelper.chunkSize(nrow, minHint, exactHint);
        int nchunks = (int)((nrow - 1L) / (long)chunkSz) + 1;
        long[] espc = new long[nchunks + 1];
        for (int i = 0; i < nchunks; ++i) {
            espc[i] = i * chunkSz;
        }
        espc[nchunks] = nrow;
        Vec vtemplate = new Vec(vg.addVec(), espc);
        Vec[] vecs = vtemplate.makeCons(ncol, 0L, (String[][])null, null);
        return new Frame(vecs);
    }

    public static Vec makeEmptyStrVec(final Vec template) {
        final int nChunks = template.nChunks();
        Key key = template.group().addVec();
        final Vec emptystr = new Vec(key, template._espc, null, 3);
        new MRTask(){

            protected void setupLocal() {
                for (int i = 0; i < nChunks; ++i) {
                    Key k = emptystr.chunkKey(i);
                    int chklen = H2OHelper.vecChunkLen(template, i);
                    int[] stridx = new int[chklen];
                    byte[] b = new byte[]{0};
                    for (int j = 0; j < chklen; ++j) {
                        stridx[j] = -1;
                    }
                    if (!k.home()) continue;
                    DKV.put((Key)k, (Iced)new CStrChunk(1, b, chklen, stridx), (Futures)this._fs);
                }
                if (emptystr._key.home()) {
                    DKV.put((Key)emptystr._key, (Iced)emptystr, (Futures)this._fs);
                }
            }
        }.doAllNodes();
        return emptystr;
    }

    public static int vecChunkLen(Vec template, int chunk) {
        return (int)(template._espc[chunk + 1] - template._espc[chunk]);
    }

    public static H2ODrm emptyDrm(long nrow, int ncol, int minHint, int exactHint) {
        return new H2ODrm(H2OHelper.emptyFrame(nrow, ncol, minHint, exactHint));
    }

    public static Matrix allreduceBlock(H2ODrm drmA, Object bmfn, Object rfn) {
        class MRTaskMR
        extends MRTask<MRTaskMR> {
            H2OBCast<Matrix> bmf_out;
            Serializable bmf;
            Serializable rf;

            public MRTaskMR(Object _bmf, Object _rf) {
                this.bmf = (Serializable)_bmf;
                this.rf = (Serializable)_rf;
            }

            public void map(Chunk[] chks) {
                Function1 f = (Function1)this.bmf;
                this.bmf_out = new H2OBCast<Matrix>((Matrix)f.apply((Object)new Tuple2(null, (Object)new H2OBlockMatrix(chks))));
            }

            public void reduce(MRTaskMR that) {
                Function2 f = (Function2)this.rf;
                this.bmf_out = new H2OBCast<Matrix>((Matrix)f.apply((Object)this.bmf_out.value(), (Object)that.bmf_out.value()));
            }
        }
        return ((MRTaskMR)new MRTaskMR((Object)bmfn, (Object)rfn).doAll((Frame)drmA.frame)).bmf_out.value();
    }
}

