/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.mahout.h2obindings.H2OHelper;
import org.apache.mahout.h2obindings.drm.H2ODrm;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import water.Futures;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.ValueString;
import water.util.FrameUtils;

public class H2OHdfs {
    public static boolean isSeqfile(String filename) {
        try {
            Configuration conf = new Configuration();
            Path path = new Path(filename);
            FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)conf);
            FSDataInputStream fin = fs.open(path);
            byte[] seq = new byte[3];
            fin.read(seq);
            fin.close();
            return seq[0] == 83 && seq[1] == 69 && seq[2] == 81;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static H2ODrm drmFromFile(String filename, int parMin) {
        try {
            if (H2OHdfs.isSeqfile(filename)) {
                return H2OHdfs.drmFromSeqfile(filename, parMin);
            }
            return new H2ODrm(FrameUtils.parseFrame(null, (File)new File(filename)));
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static H2ODrm drmFromSeqfile(String filename, int parMin) {
        long rows = 0L;
        int cols = 0;
        Frame frame = null;
        Vec labels = null;
        SequenceFile.Reader reader = null;
        try {
            Configuration conf = new Configuration();
            Path path = new Path(filename);
            FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)conf);
            Vec.Writer labelwriter = null;
            boolean isIntKey = false;
            boolean isLongKey = false;
            boolean isStringKey = false;
            reader = new SequenceFile.Reader(fs, path, conf);
            if (reader.getValueClass() != VectorWritable.class) {
                System.out.println("ValueClass in file " + filename + "must be VectorWritable, but found " + reader.getValueClassName());
                H2ODrm h2ODrm = null;
                IOUtils.closeStream((Closeable)reader);
                return h2ODrm;
            }
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            VectorWritable value = (VectorWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            long start = reader.getPosition();
            if (reader.getKeyClass() == Text.class) {
                isStringKey = true;
            } else if (reader.getKeyClass() == LongWritable.class) {
                isLongKey = true;
            } else {
                isIntKey = true;
            }
            while (reader.next(key, (Writable)value)) {
                if (cols == 0) {
                    Vector v = value.get();
                    cols = Math.max(v.size(), cols);
                }
                if (isLongKey) {
                    rows = Math.max(((LongWritable)key).get() + 1L, rows);
                }
                if (isIntKey) {
                    rows = Math.max((long)(((IntWritable)key).get() + 1), rows);
                }
                if (!isStringKey) continue;
                ++rows;
            }
            reader.seek(start);
            frame = H2OHelper.emptyFrame(rows, cols, parMin, -1);
            Vec.Writer[] writers = new Vec.Writer[cols];
            for (int i = 0; i < writers.length; ++i) {
                writers[i] = frame.vecs()[i].open();
            }
            if (reader.getKeyClass() == Text.class) {
                labels = H2OHelper.makeEmptyStrVec(frame.anyVec());
                labelwriter = labels.open();
            }
            long r = 0L;
            while (reader.next(key, (Writable)value)) {
                Vector v = value.get();
                if (isLongKey) {
                    r = ((LongWritable)key).get();
                }
                if (isIntKey) {
                    r = ((IntWritable)key).get();
                }
                for (int c = 0; c < v.size(); ++c) {
                    writers[c].set(r, v.getQuick(c));
                }
                if (labels != null) {
                    labelwriter.set(r, key.toString());
                }
                if (!isStringKey) continue;
                ++r;
            }
            Futures fus = new Futures();
            for (Vec.Writer w : writers) {
                w.close(fus);
            }
            if (labelwriter != null) {
                labelwriter.close(fus);
            }
            fus.blockForPending();
            IOUtils.closeStream((Closeable)reader);
        }
        catch (IOException e) {
            H2ODrm h2ODrm = null;
            return h2ODrm;
        }
        finally {
            IOUtils.closeStream(reader);
        }
        return new H2ODrm(frame, labels);
    }

    public static void drmToFile(String filename, H2ODrm drm) throws IOException {
        Frame frame = drm.frame;
        Vec labels = drm.keys;
        Configuration conf = new Configuration();
        Path path = new Path(filename);
        FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)conf);
        boolean isSparse = H2OHelper.isSparse(frame);
        ValueString vstr = new ValueString();
        SequenceFile.Writer writer = labels != null ? SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, Text.class, VectorWritable.class) : SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, IntWritable.class, VectorWritable.class);
        for (long r = 0L; r < frame.anyVec().length(); ++r) {
            Object v = isSparse ? new SequentialAccessSparseVector(frame.numCols()) : new DenseVector(frame.numCols());
            for (int c = 0; c < frame.numCols(); ++c) {
                v.setQuick(c, frame.vecs()[c].at(r));
            }
            if (labels != null) {
                writer.append((Writable)new Text(labels.atStr(vstr, r).toString()), (Writable)new VectorWritable((Vector)v));
                continue;
            }
            writer.append((Writable)new IntWritable((int)r), (Writable)new VectorWritable((Vector)v));
        }
        writer.close();
    }
}

