/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.Varint;

public class Gram
extends BinaryComparable
implements WritableComparable<BinaryComparable> {
    private byte[] bytes;
    private int length;
    private int frequency;

    public Gram() {
    }

    public Gram(Gram other) {
        this.frequency = other.frequency;
        this.length = other.length;
        this.bytes = (byte[])other.bytes.clone();
    }

    public Gram(String ngram, Type type) {
        this(ngram, 1, type);
    }

    public Gram(String ngram, int frequency, Type type) {
        Preconditions.checkNotNull((Object)ngram);
        try {
            ByteBuffer bb = Text.encode((String)('\u0000' + ngram), (boolean)true);
            this.bytes = bb.array();
            this.length = bb.limit();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Should not have happened ", e);
        }
        Gram.encodeType(type, this.bytes, 0);
        this.frequency = frequency;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public Type getType() {
        return Gram.decodeType(this.bytes, 0);
    }

    public String getString() {
        try {
            return Text.decode((byte[])this.bytes, (int)1, (int)(this.length - 1));
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Should not have happened " + e);
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void incrementFrequency(int i) {
        this.frequency += i;
    }

    public void readFields(DataInput in) throws IOException {
        int newLength = Varint.readUnsignedVarInt((DataInput)in);
        this.setCapacity(newLength, false);
        in.readFully(this.bytes, 0, newLength);
        int newFrequency = Varint.readUnsignedVarInt((DataInput)in);
        this.length = newLength;
        this.frequency = newFrequency;
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt((int)this.length, (DataOutput)out);
        out.write(this.bytes, 0, this.length);
        Varint.writeUnsignedVarInt((int)this.frequency, (DataOutput)out);
    }

    private void setCapacity(int len, boolean keepData) {
        if (this.bytes == null || this.bytes.length < ++len) {
            byte[] newBytes = new byte[len];
            if (this.bytes != null && keepData) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            }
            this.bytes = newBytes;
        }
    }

    public String toString() {
        return '\'' + this.getString() + "'[" + (Object)((Object)this.getType()) + "]:" + this.frequency;
    }

    public static void encodeType(Type type, byte[] buf, int offset) {
        switch (type) {
            case HEAD: {
                buf[offset] = 1;
                break;
            }
            case TAIL: {
                buf[offset] = 2;
                break;
            }
            case UNIGRAM: {
                buf[offset] = 3;
                break;
            }
            case NGRAM: {
                buf[offset] = 4;
                break;
            }
            default: {
                throw new IllegalStateException("switch/case problem in encodeType");
            }
        }
    }

    public static Type decodeType(byte[] buf, int offset) {
        switch (buf[offset]) {
            case 1: {
                return Type.HEAD;
            }
            case 2: {
                return Type.TAIL;
            }
            case 3: {
                return Type.UNIGRAM;
            }
            case 4: {
                return Type.NGRAM;
            }
        }
        throw new IllegalStateException("switch/case problem in decodeType");
    }

    public static enum Type {
        HEAD('h'),
        TAIL('t'),
        UNIGRAM('u'),
        NGRAM('n');

        private final char x;

        private Type(char c) {
            this.x = c;
        }

        public String toString() {
            return String.valueOf(this.x);
        }
    }
}

