/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;

public class HashedVector
extends WeightedVector {
    protected static final int INVALID_INDEX = -1;
    private final long hash;

    public HashedVector(Vector vector, long hash, int index) {
        super(vector, 1.0, index);
        this.hash = hash;
    }

    public HashedVector(Vector vector, Matrix projection, int index, long mask) {
        super(vector, 1.0, index);
        this.hash = mask & HashedVector.computeHash64(vector, projection);
    }

    public HashedVector(WeightedVector weightedVector, Matrix projection, long mask) {
        super(weightedVector.getVector(), weightedVector.getWeight(), weightedVector.getIndex());
        this.hash = mask & HashedVector.computeHash64((Vector)weightedVector, projection);
    }

    public static long computeHash64(Vector vector, Matrix projection) {
        long hash = 0L;
        for (Vector.Element element : projection.times(vector).nonZeroes()) {
            if (!(element.get() > 0.0)) continue;
            hash += 1L << element.index();
        }
        return hash;
    }

    public static HashedVector hash(WeightedVector v, Matrix projection) {
        return HashedVector.hash(v, projection, 0L);
    }

    public static HashedVector hash(WeightedVector v, Matrix projection, long mask) {
        return new HashedVector(v, projection, mask);
    }

    public int hammingDistance(long otherHash) {
        return Long.bitCount(this.hash ^ otherHash);
    }

    public long getHash() {
        return this.hash;
    }

    public String toString() {
        return String.format("index=%d, hash=%08x, v=%s", this.getIndex(), this.hash, this.getVector());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashedVector)) {
            return o instanceof Vector && this.minus((Vector)o).norm(1.0) == 0.0;
        }
        HashedVector v = (HashedVector)((Object)o);
        return v.hash == this.hash && this.minus((Vector)v).norm(1.0) == 0.0;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.hash ^ this.hash >>> 32);
        return result;
    }
}

