/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;
import org.apache.mahout.math.random.RandomProjector;
import org.apache.mahout.math.random.WeightedThing;

public class FastProjectionSearch
extends UpdatableSearcher {
    private final List<Vector> pendingAdditions = Lists.newArrayList();
    private Matrix basisMatrix = null;
    private List<List<WeightedThing<Vector>>> scalarProjections;
    private final int numProjections;
    private final int searchSize;
    private boolean initialized = false;
    private int numPendingRemovals = 0;
    private static final double ADDITION_THRESHOLD = 0.05;
    private static final double REMOVAL_THRESHOLD = 0.02;

    public FastProjectionSearch(DistanceMeasure distanceMeasure, int numProjections, int searchSize) {
        super(distanceMeasure);
        Preconditions.checkArgument((numProjections > 0 && numProjections < 100 ? 1 : 0) != 0, (Object)"Unreasonable value for number of projections. Must be: 0 < numProjections < 100");
        this.numProjections = numProjections;
        this.searchSize = searchSize;
        this.scalarProjections = Lists.newArrayListWithCapacity((int)numProjections);
        for (int i = 0; i < numProjections; ++i) {
            this.scalarProjections.add(Lists.newArrayList());
        }
    }

    private void initialize(int numDimensions) {
        if (this.initialized) {
            return;
        }
        this.basisMatrix = RandomProjector.generateBasisNormal(this.numProjections, numDimensions);
        this.initialized = true;
    }

    @Override
    public void add(Vector vector) {
        this.initialize(vector.size());
        this.pendingAdditions.add(vector);
    }

    @Override
    public int size() {
        return this.pendingAdditions.size() + this.scalarProjections.get(0).size() - this.numPendingRemovals;
    }

    @Override
    public List<WeightedThing<Vector>> search(Vector query, int limit) {
        this.reindex(false);
        HashSet candidates = Sets.newHashSet();
        Vector projection = this.basisMatrix.times(query);
        for (int i = 0; i < this.basisMatrix.numRows(); ++i) {
            List<WeightedThing<Vector>> currProjections = this.scalarProjections.get(i);
            int middle = Collections.binarySearch(currProjections, new WeightedThing(projection.get(i)));
            if (middle < 0) {
                middle = -(middle + 1);
            }
            for (int j = Math.max(0, middle - this.searchSize); j < Math.min(currProjections.size(), middle + this.searchSize + 1); ++j) {
                if (currProjections.get(j).getValue() == null) continue;
                candidates.add(currProjections.get(j).getValue());
            }
        }
        ArrayList top = Lists.newArrayListWithCapacity((int)(candidates.size() + this.pendingAdditions.size()));
        for (Vector candidate : Iterables.concat((Iterable)candidates, this.pendingAdditions)) {
            top.add(new WeightedThing((Object)candidate, this.distanceMeasure.distance(candidate, query)));
        }
        Collections.sort(top);
        return top.subList(0, Math.min(top.size(), limit));
    }

    @Override
    public WeightedThing<Vector> searchFirst(Vector query, boolean differentThanQuery) {
        this.reindex(false);
        double bestDistance = Double.POSITIVE_INFINITY;
        Vector bestVector = null;
        Vector projection = this.basisMatrix.times(query);
        for (int i = 0; i < this.basisMatrix.numRows(); ++i) {
            List<WeightedThing<Vector>> currProjections = this.scalarProjections.get(i);
            int middle = Collections.binarySearch(currProjections, new WeightedThing(projection.get(i)));
            if (middle < 0) {
                middle = -(middle + 1);
            }
            for (int j = Math.max(0, middle - this.searchSize); j < Math.min(currProjections.size(), middle + this.searchSize + 1); ++j) {
                Vector vector;
                double distance;
                if (currProjections.get(j).getValue() == null || !((distance = this.distanceMeasure.distance(vector = (Vector)currProjections.get(j).getValue(), query)) < bestDistance) || differentThanQuery && vector.equals(query)) continue;
                bestDistance = distance;
                bestVector = vector;
            }
        }
        for (Vector vector : this.pendingAdditions) {
            double distance = this.distanceMeasure.distance(vector, query);
            if (!(distance < bestDistance) || differentThanQuery && vector.equals(query)) continue;
            bestDistance = distance;
            bestVector = vector;
        }
        return new WeightedThing(bestVector, bestDistance);
    }

    @Override
    public boolean remove(Vector vector, double epsilon) {
        int i;
        WeightedThing<Vector> closestPair = this.searchFirst(vector, false);
        if (this.distanceMeasure.distance((Vector)closestPair.getValue(), vector) > epsilon) {
            return false;
        }
        boolean isProjected = true;
        Vector projection = this.basisMatrix.times(vector);
        for (i = 0; i < this.basisMatrix.numRows(); ++i) {
            WeightedThing searchedThing;
            List<WeightedThing<Vector>> currProjections = this.scalarProjections.get(i);
            int middle = Collections.binarySearch(currProjections, searchedThing = new WeightedThing(projection.get(i)));
            if (middle < 0) {
                isProjected = false;
                break;
            }
            this.scalarProjections.get(i).set(middle, (WeightedThing<Vector>)searchedThing);
        }
        if (isProjected) {
            ++this.numPendingRemovals;
            return true;
        }
        for (i = 0; i < this.pendingAdditions.size(); ++i) {
            if (!this.pendingAdditions.get(i).equals(vector)) continue;
            this.pendingAdditions.remove(i);
            break;
        }
        return true;
    }

    private void reindex(boolean force) {
        int numProjected = this.scalarProjections.get(0).size();
        if (force || (double)this.pendingAdditions.size() > 0.05 * (double)numProjected || (double)this.numPendingRemovals > 0.02 * (double)numProjected) {
            ArrayList scalarProjections = Lists.newArrayListWithCapacity((int)this.numProjections);
            for (int i = 0; i < this.numProjections; ++i) {
                if (i == 0) {
                    scalarProjections.add(Lists.newArrayList((Iterable)this.scalarProjections.get(i)));
                    continue;
                }
                scalarProjections.add(this.scalarProjections.get(i));
            }
            for (Vector pending : this.pendingAdditions) {
                Vector projection = this.basisMatrix.times(pending);
                for (int i = 0; i < this.numProjections; ++i) {
                    ((List)scalarProjections.get(i)).add(new WeightedThing((Object)pending, projection.get(i)));
                }
            }
            this.pendingAdditions.clear();
            for (int i = 0; i < this.numProjections; ++i) {
                List currProjections = (List)scalarProjections.get(i);
                for (WeightedThing v : currProjections) {
                    if (v.getValue() != null) continue;
                    v.setWeight(Double.POSITIVE_INFINITY);
                }
                Collections.sort(currProjections);
                for (int j = 0; j < this.numPendingRemovals; ++j) {
                    currProjections.remove(currProjections.size() - 1);
                }
            }
            this.numPendingRemovals = 0;
            this.scalarProjections = scalarProjections;
        }
    }

    @Override
    public void clear() {
        this.pendingAdditions.clear();
        for (int i = 0; i < this.numProjections; ++i) {
            this.scalarProjections.get(i).clear();
        }
        this.numPendingRemovals = 0;
    }

    @Override
    public Iterator<Vector> iterator() {
        this.reindex(true);
        return new AbstractIterator<Vector>(){
            private final Iterator<WeightedThing<Vector>> data;
            {
                this.data = ((List)FastProjectionSearch.this.scalarProjections.get(0)).iterator();
            }

            protected Vector computeNext() {
                WeightedThing<Vector> next;
                do {
                    if (this.data.hasNext()) continue;
                    return (Vector)this.endOfData();
                } while ((next = this.data.next()).getValue() == null);
                return (Vector)next.getValue();
            }
        };
    }
}

