/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stats;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.hadoop.stats.StandardDeviationCalculatorMapper;
import org.apache.mahout.math.hadoop.stats.StandardDeviationCalculatorReducer;
import org.apache.mahout.math.hadoop.stats.VarianceTotals;

public final class BasicStats {
    private BasicStats() {
    }

    public static double variance(Path input, Path output, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        VarianceTotals varianceTotals = BasicStats.computeVarianceTotals(input, output, baseConf);
        return varianceTotals.computeVariance();
    }

    public static double varianceForGivenMean(Path input, Path output, double mean, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        VarianceTotals varianceTotals = BasicStats.computeVarianceTotals(input, output, baseConf);
        return varianceTotals.computeVarianceForGivenMean(mean);
    }

    private static VarianceTotals computeVarianceTotals(Path input, Path output, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration(baseConf);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        Job job = HadoopUtil.prepareJob(input, output, SequenceFileInputFormat.class, StandardDeviationCalculatorMapper.class, IntWritable.class, DoubleWritable.class, StandardDeviationCalculatorReducer.class, IntWritable.class, DoubleWritable.class, SequenceFileOutputFormat.class, conf);
        HadoopUtil.delete(conf, output);
        job.setCombinerClass(StandardDeviationCalculatorReducer.class);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
        Path filesPattern = new Path(output, "part-*");
        double sumOfSquares = 0.0;
        double sum = 0.0;
        double totalCount = 0.0;
        for (Pair record : new SequenceFileDirIterable(filesPattern, PathType.GLOB, null, null, true, conf)) {
            int key = ((IntWritable)record.getFirst()).get();
            if (key == StandardDeviationCalculatorMapper.SUM_OF_SQUARES.get()) {
                sumOfSquares += ((DoubleWritable)record.getSecond()).get();
                continue;
            }
            if (key == StandardDeviationCalculatorMapper.TOTAL_COUNT.get()) {
                totalCount += ((DoubleWritable)record.getSecond()).get();
                continue;
            }
            if (key != StandardDeviationCalculatorMapper.SUM.get()) continue;
            sum += ((DoubleWritable)record.getSecond()).get();
        }
        VarianceTotals varianceTotals = new VarianceTotals();
        varianceTotals.setSum(sum);
        varianceTotals.setSumOfSquares(sumOfSquares);
        varianceTotals.setTotalCount(totalCount);
        return varianceTotals;
    }

    public static double stdDev(Path input, Path output, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        return Math.sqrt(BasicStats.variance(input, output, baseConf));
    }

    public static double stdDevForGivenMean(Path input, Path output, double mean, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        return Math.sqrt(BasicStats.varianceForGivenMean(input, output, mean, baseConf));
    }
}

