/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomSeedGenerator {
    private static final Logger log = LoggerFactory.getLogger(RandomSeedGenerator.class);
    public static final String K = "k";

    private RandomSeedGenerator() {
    }

    public static Path buildRandom(Configuration conf, Path input, Path output, int k, DistanceMeasure measure) throws IOException {
        return RandomSeedGenerator.buildRandom(conf, input, output, k, measure, null);
    }

    public static Path buildRandom(Configuration conf, Path input, Path output, int k, DistanceMeasure measure, Long seed) throws IOException {
        Preconditions.checkArgument((k > 0 ? 1 : 0) != 0, (Object)("Must be: k > 0, but k = " + k));
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        HadoopUtil.delete(conf, output);
        Path outFile = new Path(output, "part-randomSeed");
        boolean newFile = fs.createNewFile(outFile);
        if (newFile) {
            Path inputPathPattern = fs.getFileStatus(input).isDir() ? new Path(input, "*") : input;
            FileStatus[] inputFiles = fs.globStatus(inputPathPattern, PathFilters.logsCRCFilter());
            RandomWrapper random = seed != null ? RandomUtils.getRandom((long)seed) : RandomUtils.getRandom();
            ArrayList<Text> chosenTexts = new ArrayList<Text>(k);
            ArrayList<ClusterWritable> chosenClusters = new ArrayList<ClusterWritable>(k);
            int nextClusterId = 0;
            int index = 0;
            for (FileStatus fileStatus : inputFiles) {
                if (fileStatus.isDir()) continue;
                for (Pair record : new SequenceFileIterable(fileStatus.getPath(), true, conf)) {
                    Writable key = (Writable)record.getFirst();
                    VectorWritable value = (VectorWritable)record.getSecond();
                    Kluster newCluster = new Kluster(value.get(), nextClusterId++, measure);
                    newCluster.observe(value.get(), 1.0);
                    Text newText = new Text(key.toString());
                    int currentSize = chosenTexts.size();
                    if (currentSize < k) {
                        chosenTexts.add(newText);
                        ClusterWritable clusterWritable = new ClusterWritable();
                        clusterWritable.setValue(newCluster);
                        chosenClusters.add(clusterWritable);
                    } else {
                        int j = random.nextInt(index);
                        if (j < k) {
                            chosenTexts.set(j, newText);
                            ClusterWritable clusterWritable = new ClusterWritable();
                            clusterWritable.setValue(newCluster);
                            chosenClusters.set(j, clusterWritable);
                        }
                    }
                    ++index;
                }
            }
            try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)outFile, Text.class, ClusterWritable.class);){
                for (int i = 0; i < chosenTexts.size(); ++i) {
                    writer.append((Writable)chosenTexts.get(i), (Writable)chosenClusters.get(i));
                }
                log.info("Wrote {} Klusters to {}", (Object)k, (Object)outFile);
            }
        }
        return outFile;
    }
}

