/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.classify;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.AbstractVectorClassifier;
import org.apache.mahout.classifier.OnlineLearner;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.clustering.iterator.ClusteringPolicyWritable;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ClusterClassifier
extends AbstractVectorClassifier
implements OnlineLearner,
Writable {
    private static final String POLICY_FILE_NAME = "_policy";
    private List<Cluster> models;
    private String modelClass;
    private ClusteringPolicy policy;

    public ClusterClassifier(List<Cluster> models, ClusteringPolicy policy) {
        this.models = models;
        this.modelClass = models.get(0).getClass().getName();
        this.policy = policy;
    }

    public ClusterClassifier() {
    }

    protected ClusterClassifier(ClusteringPolicy policy) {
        this.policy = policy;
    }

    @Override
    public Vector classify(Vector instance) {
        return this.policy.classify(instance, this);
    }

    @Override
    public double classifyScalar(Vector instance) {
        if (this.models.size() == 2) {
            double pdf0 = this.models.get(0).pdf(new VectorWritable(instance));
            double pdf1 = this.models.get(1).pdf(new VectorWritable(instance));
            return pdf0 / (pdf0 + pdf1);
        }
        throw new IllegalStateException();
    }

    @Override
    public int numCategories() {
        return this.models.size();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.models.size());
        out.writeUTF(this.modelClass);
        new ClusteringPolicyWritable(this.policy).write(out);
        for (Cluster cluster : this.models) {
            cluster.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.modelClass = in.readUTF();
        this.models = new ArrayList<Cluster>();
        ClusteringPolicyWritable clusteringPolicyWritable = new ClusteringPolicyWritable();
        clusteringPolicyWritable.readFields(in);
        this.policy = clusteringPolicyWritable.getValue();
        for (int i = 0; i < size; ++i) {
            Cluster element = ClassUtils.instantiateAs(this.modelClass, Cluster.class);
            element.readFields(in);
            this.models.add(element);
        }
    }

    @Override
    public void train(int actual, Vector instance) {
        this.models.get(actual).observe(new VectorWritable(instance));
    }

    public void train(int actual, Vector data, double weight) {
        this.models.get(actual).observe(new VectorWritable(data), weight);
    }

    @Override
    public void train(long trackingKey, String groupKey, int actual, Vector instance) {
        this.models.get(actual).observe(new VectorWritable(instance));
    }

    @Override
    public void train(long trackingKey, int actual, Vector instance) {
        this.models.get(actual).observe(new VectorWritable(instance));
    }

    @Override
    public void close() {
        this.policy.close(this);
    }

    public List<Cluster> getModels() {
        return this.models;
    }

    public ClusteringPolicy getPolicy() {
        return this.policy;
    }

    public void writeToSeqFiles(Path path) throws IOException {
        ClusterClassifier.writePolicy(this.policy, path);
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)config);
        ClusterWritable cw = new ClusterWritable();
        for (int i = 0; i < this.models.size(); ++i) {
            try (SequenceFile.Writer writer = new SequenceFile.Writer(fs, config, new Path(path, "part-" + String.format(Locale.ENGLISH, "%05d", i)), IntWritable.class, ClusterWritable.class);){
                Cluster cluster = this.models.get(i);
                cw.setValue(cluster);
                IntWritable key = new IntWritable(i);
                writer.append((Writable)key, (Writable)cw);
                continue;
            }
        }
    }

    public void readFromSeqFiles(Configuration conf, Path path) throws IOException {
        Configuration config = new Configuration();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (ClusterWritable cw : new SequenceFileDirValueIterable(path, PathType.LIST, PathFilters.logsCRCFilter(), config)) {
            Cluster cluster = cw.getValue();
            cluster.configure(conf);
            clusters.add(cluster);
        }
        this.models = clusters;
        this.modelClass = this.models.get(0).getClass().getName();
        this.policy = ClusterClassifier.readPolicy(path);
    }

    public static ClusteringPolicy readPolicy(Path path) throws IOException {
        Path policyPath = new Path(path, POLICY_FILE_NAME);
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((URI)policyPath.toUri(), (Configuration)config);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, policyPath, config);
        Text key = new Text();
        ClusteringPolicyWritable cpw = new ClusteringPolicyWritable();
        reader.next((Writable)key, (Writable)cpw);
        Closeables.close((Closeable)reader, (boolean)true);
        return cpw.getValue();
    }

    public static void writePolicy(ClusteringPolicy policy, Path path) throws IOException {
        Path policyPath = new Path(path, POLICY_FILE_NAME);
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((URI)policyPath.toUri(), (Configuration)config);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, config, policyPath, Text.class, ClusteringPolicyWritable.class);
        writer.append((Writable)new Text(), (Writable)new ClusteringPolicyWritable(policy));
        Closeables.close((Closeable)writer, (boolean)false);
    }
}

