/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.test;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.ComplementaryNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.classifier.naivebayes.StandardNaiveBayesClassifier;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class BayesTestMapper
extends Mapper<Text, VectorWritable, Text, VectorWritable> {
    private static final Pattern SLASH = Pattern.compile("/");
    private AbstractNaiveBayesClassifier classifier;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        Path modelPath = HadoopUtil.getSingleCachedFile(conf);
        NaiveBayesModel model = NaiveBayesModel.materialize(modelPath, conf);
        boolean isComplementary = Boolean.parseBoolean(conf.get("class"));
        if (isComplementary) {
            Preconditions.checkArgument((boolean)model.isComplemtary(), (Object)"Complementary mode in model is different than test mode");
        }
        this.classifier = isComplementary ? new ComplementaryNaiveBayesClassifier(model) : new StandardNaiveBayesClassifier(model);
    }

    protected void map(Text key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Vector result = this.classifier.classifyFull(value.get());
        context.write((Object)new Text(SLASH.split(key.toString())[1]), (Object)new VectorWritable(result));
    }
}

