/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.tools;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.df.data.DataConverter;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class UDistrib {
    private static final Logger log = LoggerFactory.getLogger(UDistrib.class);

    private UDistrib() {
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption dataOpt = obuilder.withLongName("data").withShortName("d").withRequired(true).withArgument(abuilder.withName("data").withMinimum(1).withMaximum(1).create()).withDescription("Data path").create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).create()).withDescription("Dataset path").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withShortName("o").withRequired(true).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("Path to generated files").create();
        DefaultOption partitionsOpt = obuilder.withLongName("numpartitions").withShortName("p").withRequired(true).withArgument(abuilder.withName("numparts").withMinimum(1).withMinimum(1).create()).withDescription("Number of partitions to create").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)dataOpt).withOption((Option)outputOpt).withOption((Option)datasetOpt).withOption((Option)partitionsOpt).withOption((Option)helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                CommandLineUtil.printHelp(group);
                return;
            }
            String data = cmdLine.getValue((Option)dataOpt).toString();
            String dataset = cmdLine.getValue((Option)datasetOpt).toString();
            int numPartitions = Integer.parseInt(cmdLine.getValue((Option)partitionsOpt).toString());
            String output = cmdLine.getValue((Option)outputOpt).toString();
            UDistrib.runTool(data, dataset, output, numPartitions);
        }
        catch (OptionException e) {
            log.warn(e.toString(), (Throwable)e);
            CommandLineUtil.printHelp(group);
        }
    }

    private static void runTool(String dataStr, String datasetStr, String output, int numPartitions) throws IOException {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"numPartitions <= 0");
        Path outputPath = new Path(output);
        Configuration conf = new Configuration();
        FileSystem fs = outputPath.getFileSystem(conf);
        Preconditions.checkArgument((!fs.exists(outputPath) ? 1 : 0) != 0, (Object)"Output path already exists");
        File tempFile = FileUtil.createLocalTempFile((File)new File(""), (String)"df.tools.UDistrib", (boolean)true);
        Path partsPath = new Path(tempFile.toString());
        FileSystem pfs = partsPath.getFileSystem(conf);
        Path[] partPaths = new Path[numPartitions];
        FSDataOutputStream[] files = new FSDataOutputStream[numPartitions];
        for (int p = 0; p < numPartitions; ++p) {
            partPaths[p] = new Path(partsPath, String.format(Locale.ENGLISH, "part.%03d", p));
            files[p] = pfs.create(partPaths[p]);
        }
        Path datasetPath = new Path(datasetStr);
        Dataset dataset = Dataset.load(conf, datasetPath);
        int[] currents = new int[dataset.nblabels()];
        RandomWrapper random = RandomUtils.getRandom();
        for (int c = 0; c < currents.length; ++c) {
            currents[c] = random.nextInt(numPartitions);
        }
        Path dataPath = new Path(dataStr);
        FileSystem ifs = dataPath.getFileSystem(conf);
        FSDataInputStream input = ifs.open(dataPath);
        Scanner scanner = new Scanner((InputStream)input, "UTF-8");
        DataConverter converter = new DataConverter(dataset);
        int id = 0;
        while (scanner.hasNextLine()) {
            String line;
            if (id % 1000 == 0) {
                log.info("progress : {}", (Object)id);
            }
            if ((line = scanner.nextLine()).isEmpty()) continue;
            Instance instance = converter.convert(line);
            int label = (int)dataset.getLabel(instance);
            files[currents[label]].writeBytes(line);
            files[currents[label]].writeChar(10);
            int n = label;
            currents[n] = currents[n] + 1;
            if (currents[label] != numPartitions) continue;
            currents[label] = 0;
        }
        scanner.close();
        for (FSDataOutputStream file : files) {
            Closeables.close((Closeable)file, (boolean)false);
        }
        FileUtil.copyMerge((FileSystem)pfs, (Path)partsPath, (FileSystem)fs, (Path)outputPath, (boolean)true, (Configuration)conf, null);
    }
}

