/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.precompute;

import com.google.common.io.Closeables;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.Charsets;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItem;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItems;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItemsWriter;

public class FileSimilarItemsWriter
implements SimilarItemsWriter {
    private final File file;
    private BufferedWriter writer;

    public FileSimilarItemsWriter(File file) {
        this.file = file;
    }

    @Override
    public void open() throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charsets.UTF_8));
    }

    @Override
    public void add(SimilarItems similarItems) throws IOException {
        String itemID = String.valueOf(similarItems.getItemID());
        for (SimilarItem similarItem : similarItems.getSimilarItems()) {
            this.writer.write(itemID);
            this.writer.write(44);
            this.writer.write(String.valueOf(similarItem.getItemID()));
            this.writer.write(44);
            this.writer.write(String.valueOf(similarItem.getSimilarity()));
            this.writer.newLine();
        }
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Closeable)this.writer, (boolean)false);
    }
}

