/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

public abstract class AbstractItemSimilarity
implements ItemSimilarity {
    private final DataModel dataModel;
    private final RefreshHelper refreshHelper;

    protected AbstractItemSimilarity(DataModel dataModel) {
        Preconditions.checkArgument((dataModel != null ? 1 : 0) != 0, (Object)"dataModel is null");
        this.dataModel = dataModel;
        this.refreshHelper = new RefreshHelper(null);
        this.refreshHelper.addDependency(this.dataModel);
    }

    protected DataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public long[] allSimilarItemIDs(long itemID) throws TasteException {
        FastIDSet allSimilarItemIDs = new FastIDSet();
        LongPrimitiveIterator allItemIDs = this.dataModel.getItemIDs();
        while (allItemIDs.hasNext()) {
            long possiblySimilarItemID = allItemIDs.nextLong();
            if (Double.isNaN(this.itemSimilarity(itemID, possiblySimilarItemID))) continue;
            allSimilarItemIDs.add(possiblySimilarItemID);
        }
        return allSimilarItemIDs.toArray();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }
}

