/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.neighborhood;

import com.google.common.base.Preconditions;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.neighborhood.AbstractUserNeighborhood;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class ThresholdUserNeighborhood
extends AbstractUserNeighborhood {
    private final double threshold;

    public ThresholdUserNeighborhood(double threshold, UserSimilarity userSimilarity, DataModel dataModel) {
        this(threshold, userSimilarity, dataModel, 1.0);
    }

    public ThresholdUserNeighborhood(double threshold, UserSimilarity userSimilarity, DataModel dataModel, double samplingRate) {
        super(userSimilarity, dataModel, samplingRate);
        Preconditions.checkArgument((!Double.isNaN(threshold) ? 1 : 0) != 0, (Object)"threshold must not be NaN");
        this.threshold = threshold;
    }

    @Override
    public long[] getUserNeighborhood(long userID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        FastIDSet neighborhood = new FastIDSet();
        LongPrimitiveIterator usersIterable = SamplingLongPrimitiveIterator.maybeWrapIterator(dataModel.getUserIDs(), this.getSamplingRate());
        UserSimilarity userSimilarityImpl = this.getUserSimilarity();
        while (usersIterable.hasNext()) {
            double theSimilarity;
            long otherUserID = (Long)usersIterable.next();
            if (userID == otherUserID || Double.isNaN(theSimilarity = userSimilarityImpl.userSimilarity(userID, otherUserID)) || !(theSimilarity >= this.threshold)) continue;
            neighborhood.add(otherUserID);
        }
        return neighborhood.toArray();
    }

    public String toString() {
        return "ThresholdUserNeighborhood";
    }
}

