/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import org.apache.lucene.facet.associations.CategoryAssociation;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;

public class CategoryFloatAssociation
implements CategoryAssociation {
    public static final String ASSOCIATION_LIST_ID = "$assoc_float$";
    private float value;

    public CategoryFloatAssociation() {
    }

    public CategoryFloatAssociation(float value) {
        this.value = value;
    }

    @Override
    public void serialize(ByteArrayDataOutput output) {
        try {
            output.writeInt(Float.floatToIntBits(this.value));
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception writing to a byte[]", e);
        }
    }

    @Override
    public void deserialize(ByteArrayDataInput input) {
        this.value = Float.intBitsToFloat(input.readInt());
    }

    @Override
    public int maxBytesNeeded() {
        return 4;
    }

    @Override
    public String getCategoryListID() {
        return ASSOCIATION_LIST_ID;
    }

    public float getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.value + ")";
    }
}

