/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.clients.consumer.internals.DelayedTask;
import org.apache.kafka.clients.consumer.internals.DelayedTaskQueue;
import org.junit.Assert;
import org.junit.Test;

public class DelayedTaskQueueTest {
    private DelayedTaskQueue scheduler = new DelayedTaskQueue();
    private ArrayList<DelayedTask> executed = new ArrayList();

    @Test
    public void testScheduling() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.poll(0L);
        Assert.assertEquals(Collections.emptyList(), this.executed);
        TestTask task1 = new TestTask();
        TestTask task2 = new TestTask();
        TestTask task3 = new TestTask();
        this.scheduler.add((DelayedTask)task1, 20L);
        Assert.assertEquals((long)20L, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.add((DelayedTask)task2, 10L);
        Assert.assertEquals((long)10L, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.add((DelayedTask)task3, 30L);
        Assert.assertEquals((long)10L, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.poll(5L);
        Assert.assertEquals(Collections.emptyList(), this.executed);
        Assert.assertEquals((long)5L, (long)this.scheduler.nextTimeout(5L));
        this.scheduler.poll(10L);
        Assert.assertEquals(Arrays.asList(task2), this.executed);
        Assert.assertEquals((long)10L, (long)this.scheduler.nextTimeout(10L));
        this.scheduler.poll(20L);
        Assert.assertEquals(Arrays.asList(task2, task1), this.executed);
        Assert.assertEquals((long)20L, (long)this.scheduler.nextTimeout(10L));
        this.scheduler.poll(30L);
        Assert.assertEquals(Arrays.asList(task2, task1, task3), this.executed);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.scheduler.nextTimeout(30L));
    }

    @Test
    public void testRemove() {
        TestTask task1 = new TestTask();
        TestTask task2 = new TestTask();
        TestTask task3 = new TestTask();
        this.scheduler.add((DelayedTask)task1, 20L);
        this.scheduler.add((DelayedTask)task2, 10L);
        this.scheduler.add((DelayedTask)task3, 30L);
        this.scheduler.add((DelayedTask)task1, 40L);
        Assert.assertEquals((long)10L, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.remove((DelayedTask)task2);
        Assert.assertEquals((long)20L, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.remove((DelayedTask)task1);
        Assert.assertEquals((long)30L, (long)this.scheduler.nextTimeout(0L));
        this.scheduler.remove((DelayedTask)task3);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.scheduler.nextTimeout(0L));
    }

    private class TestTask
    implements DelayedTask {
        private TestTask() {
        }

        public void run(long now) {
            DelayedTaskQueueTest.this.executed.add(this);
        }
    }
}

