/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.junit.Assert;
import org.junit.Test;

public class ConsumerProtocolTest {
    @Test
    public void serializeDeserializeMetadata() {
        PartitionAssignor.Subscription subscription = new PartitionAssignor.Subscription(Arrays.asList("foo", "bar"));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((PartitionAssignor.Subscription)subscription);
        PartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assert.assertEquals((Object)subscription.topics(), (Object)parsedSubscription.topics());
    }

    @Test
    public void deserializeNewSubscriptionVersion() {
        short version = 100;
        Schema subscriptionSchemaV100 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf(Type.STRING)), new Field("user_data", Type.BYTES), new Field("foo", Type.STRING)});
        Struct subscriptionV100 = new Struct(subscriptionSchemaV100);
        subscriptionV100.set("topics", (Object)new Object[]{"topic"});
        subscriptionV100.set("user_data", (Object)ByteBuffer.wrap(new byte[0]));
        subscriptionV100.set("foo", (Object)"bar");
        Struct headerV100 = new Struct(ConsumerProtocol.CONSUMER_PROTOCOL_HEADER_SCHEMA);
        headerV100.set("version", (Object)version);
        ByteBuffer buffer = ByteBuffer.allocate(subscriptionV100.sizeOf() + headerV100.sizeOf());
        headerV100.writeTo(buffer);
        subscriptionV100.writeTo(buffer);
        buffer.flip();
        PartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assert.assertEquals(Arrays.asList("topic"), (Object)subscription.topics());
    }

    @Test
    public void serializeDeserializeAssignment() {
        List<TopicPartition> partitions = Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 2));
        ByteBuffer buffer = ConsumerProtocol.serializeAssignment((PartitionAssignor.Assignment)new PartitionAssignor.Assignment(partitions));
        PartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assert.assertEquals(ConsumerProtocolTest.toSet(partitions), ConsumerProtocolTest.toSet(parsedAssignment.partitions()));
    }

    @Test
    public void deserializeNewAssignmentVersion() {
        short version = 100;
        Schema assignmentSchemaV100 = new Schema(new Field[]{new Field("topic_partitions", (Type)new ArrayOf((Type)ConsumerProtocol.TOPIC_ASSIGNMENT_V0)), new Field("user_data", Type.BYTES), new Field("foo", Type.STRING)});
        Struct assignmentV100 = new Struct(assignmentSchemaV100);
        assignmentV100.set("topic_partitions", (Object)new Object[]{new Struct(ConsumerProtocol.TOPIC_ASSIGNMENT_V0).set("topic", (Object)"foo").set("partitions", (Object)new Object[]{1})});
        assignmentV100.set("user_data", (Object)ByteBuffer.wrap(new byte[0]));
        assignmentV100.set("foo", (Object)"bar");
        Struct headerV100 = new Struct(ConsumerProtocol.CONSUMER_PROTOCOL_HEADER_SCHEMA);
        headerV100.set("version", (Object)version);
        ByteBuffer buffer = ByteBuffer.allocate(assignmentV100.sizeOf() + headerV100.sizeOf());
        headerV100.writeTo(buffer);
        assignmentV100.writeTo(buffer);
        buffer.flip();
        PartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assert.assertEquals(ConsumerProtocolTest.toSet(Arrays.asList(new TopicPartition("foo", 1))), ConsumerProtocolTest.toSet(assignment.partitions()));
    }

    private static <T> Set<T> toSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }
}

