/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;

public class JoinGroupRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.JOIN_GROUP.id);
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String SESSION_TIMEOUT_KEY_NAME = "session_timeout";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String CONSUMER_ID_KEY_NAME = "consumer_id";
    private static final String STRATEGY_KEY_NAME = "partition_assignment_strategy";
    public static final String UNKNOWN_CONSUMER_ID = "";
    private final String groupId;
    private final int sessionTimeout;
    private final List<String> topics;
    private final String consumerId;
    private final String strategy;

    public JoinGroupRequest(String groupId, int sessionTimeout, List<String> topics, String consumerId, String strategy) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.struct.set(SESSION_TIMEOUT_KEY_NAME, (Object)sessionTimeout);
        this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        this.struct.set(CONSUMER_ID_KEY_NAME, (Object)consumerId);
        this.struct.set(STRATEGY_KEY_NAME, (Object)strategy);
        this.groupId = groupId;
        this.sessionTimeout = sessionTimeout;
        this.topics = topics;
        this.consumerId = consumerId;
        this.strategy = strategy;
    }

    public JoinGroupRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.sessionTimeout = struct.getInt(SESSION_TIMEOUT_KEY_NAME);
        Object[] topicsArray = struct.getArray(TOPICS_KEY_NAME);
        this.topics = new ArrayList<String>();
        for (Object topic : topicsArray) {
            this.topics.add((String)topic);
        }
        this.consumerId = struct.getString(CONSUMER_ID_KEY_NAME);
        this.strategy = struct.getString(STRATEGY_KEY_NAME);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                return new JoinGroupResponse(Errors.forException(e).code(), -1, UNKNOWN_CONSUMER_ID, Collections.<TopicPartition>emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.JOIN_GROUP.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    public List<String> topics() {
        return this.topics;
    }

    public String consumerId() {
        return this.consumerId;
    }

    public String strategy() {
        return this.strategy;
    }

    public static JoinGroupRequest parse(ByteBuffer buffer, int versionId) {
        return new JoinGroupRequest(ProtoUtils.parseRequest(ApiKeys.JOIN_GROUP.id, versionId, buffer));
    }

    public static JoinGroupRequest parse(ByteBuffer buffer) {
        return new JoinGroupRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

