/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ConsumerMetadataRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.ProduceRequest;

public abstract class AbstractRequest
extends AbstractRequestResponse {
    public AbstractRequest(Struct struct) {
        super(struct);
    }

    public abstract AbstractRequestResponse getErrorResponse(int var1, Throwable var2);

    public static AbstractRequest getRequest(int requestId, int versionId, ByteBuffer buffer) {
        switch (ApiKeys.forId(requestId)) {
            case PRODUCE: {
                return ProduceRequest.parse(buffer, versionId);
            }
            case FETCH: {
                return FetchRequest.parse(buffer, versionId);
            }
            case LIST_OFFSETS: {
                return ListOffsetRequest.parse(buffer, versionId);
            }
            case METADATA: {
                return MetadataRequest.parse(buffer, versionId);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(buffer, versionId);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(buffer, versionId);
            }
            case CONSUMER_METADATA: {
                return ConsumerMetadataRequest.parse(buffer, versionId);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(buffer, versionId);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(buffer, versionId);
            }
        }
        return null;
    }
}

