/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.apache.kafka.common.network.Send;

public class ByteBufferSend
implements Send {
    private final String destination;
    protected final ByteBuffer[] buffers;
    private int remaining;
    private int size;

    public ByteBufferSend(String destination, ByteBuffer ... buffers) {
        this.destination = destination;
        this.buffers = buffers;
        for (int i = 0; i < buffers.length; ++i) {
            this.remaining += buffers[i].remaining();
        }
        this.size = this.remaining;
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public boolean completed() {
        return this.remaining <= 0;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        long written = channel.write(this.buffers);
        if (written < 0L) {
            throw new EOFException("Wrote negative bytes to channel. This shouldn't happen.");
        }
        this.remaining = (int)((long)this.remaining - written);
        return written;
    }
}

