/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.Serializer;

public class ProducerConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("bootstrap.servers", ConfigDef.Type.LIST, "", ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("buffer.memory", ConfigDef.Type.LONG, 0x2000000L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.HIGH, "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will either block or throw an exception based on the preference specified by <code>block.on.buffer.full</code>. <p>This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.").define("retries", ConfigDef.Type.INT, 0, ConfigDef.Range.between(0, Integer.MAX_VALUE), ConfigDef.Importance.HIGH, "Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error. Note that this retry is no different than if the client resent the record upon receiving the error. Allowing retries will potentially change the ordering of records because if two records are sent to a single partition, and the first fails and is retried but the second succeeds, then the second record may appear first.").define("acks", ConfigDef.Type.STRING, "1", ConfigDef.ValidString.in("all", "-1", "0", "1"), ConfigDef.Importance.HIGH, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the  durability of records that are sent. The following settings are common:  <ul> <li><code>acks=0</code> If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the <code>retries</code> configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to -1. <li><code>acks=1</code> This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. <li><code>acks=all</code> This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee.").define("compression.type", ConfigDef.Type.STRING, "none", ConfigDef.Importance.HIGH, "The compression type for all data generated by the producer. The default is none (i.e. no compression). Valid  values are <code>none</code>, <code>gzip</code>, <code>snappy</code>, or <code>lz4</code>. Compression is of full batches of data, so the efficacy of batching will also impact the compression ratio (more batching means better compression).").define("batch.size", ConfigDef.Type.INT, 16384, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. <p>No attempt will be made to batch records larger than this size. <p>Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent. <p>A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.").define("timeout.ms", ConfigDef.Type.INT, 30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "The configuration controls the maximum amount of time the server will wait for acknowledgments from followers to meet the acknowledgment requirements the producer has specified with the <code>acks</code> configuration. If the requested number of acknowledgments are not met when the timeout elapses an error will be returned. This timeout is measured on the server side and does not include the network latency of the request.").define("linger.ms", ConfigDef.Type.LONG, 0, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.MEDIUM, "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay&mdash;that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get <code>batch.size</code> worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting <code>linger.ms=5</code>, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absense of load.").define("client.id", ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define("send.buffer.bytes", ConfigDef.Type.INT, 131072, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data.").define("receive.buffer.bytes", ConfigDef.Type.INT, 32768, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.").define("max.request.size", ConfigDef.Type.INT, 0x100000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "The maximum size of a request. This is also effectively a cap on the maximum record size. Note that the server has its own cap on record size which may be different from this. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.").define("block.on.buffer.full", ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, "When our memory buffer is exhausted we must either stop accepting new records (block) or throw errors. By default this setting is true and we block, however in some scenarios blocking is not desirable and it is better to immediately give an error. Setting this to <code>false</code> will accomplish that: the producer will throw a BufferExhaustedException if a recrord is sent and the buffer space is full.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, 50L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all requests sent by the consumer to the broker.").define("metric.reporters", ConfigDef.Type.LIST, "", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>MetricReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("retry.backoff.ms", ConfigDef.Type.LONG, 100L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed fetch request to a given topic partition. This avoids repeated fetching-and-failing in a tight loop.").define("metadata.fetch.timeout.ms", ConfigDef.Type.LONG, 60000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The first time data is sent to a topic we must fetch metadata about that topic to know which servers host the topic's partitions. This fetch to succeed before throwing an exception back to the client.").define("metadata.max.age.ms", ConfigDef.Type.LONG, 300000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("metrics.sample.window.ms", ConfigDef.Type.LONG, 30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define("metrics.num.samples", ConfigDef.Type.INT, 2, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define("max.in.flight.requests.per.connection", ConfigDef.Type.INT, 5, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).").define("key.serializer", ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, "Serializer class for key that implements the <code>Serializer</code> interface.").define("value.serializer", ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, "Serializer class for value that implements the <code>Serializer</code> interface.").define("marlin.buffer.max.time.ms", ConfigDef.Type.LONG, 3000L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.HIGH, "Messages are buffered in the producer at most the specified time.  A thread will flush all messages that have been buffered more than the specified time. The default value is 3000 (3 seconds).").define("marlin.parallel.flushers.per.partition", ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.HIGH, "This enables parallel flushers per partition.  By default, it is enabled.  If enabled, messages even within a single partition may be delivered out-of-order.").define("marlin.partitioner.class", ConfigDef.Type.CLASS, "org.apache.kafka.clients.producer.DefaultMarlinPartitioner", ConfigDef.Importance.MEDIUM, "Marlin's partitioner class that implements <code>MarlinPartitioner</code> interface.").define("connections.max.idle.ms", ConfigDef.Type.LONG, 540000, ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.").define("partitioner.class", ConfigDef.Type.CLASS, "org.apache.kafka.clients.producer.internals.DefaultPartitioner", ConfigDef.Importance.MEDIUM, "Partitioner class that implements the <code>Partitioner</code> interface.");
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String METADATA_FETCH_TIMEOUT_CONFIG = "metadata.fetch.timeout.ms";
    private static final String METADATA_FETCH_TIMEOUT_DOC = "The first time data is sent to a topic we must fetch metadata about that topic to know which servers host the topic's partitions. This fetch to succeed before throwing an exception back to the client.";
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    private static final String METADATA_MAX_AGE_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String BATCH_SIZE_CONFIG = "batch.size";
    private static final String BATCH_SIZE_DOC = "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. <p>No attempt will be made to batch records larger than this size. <p>Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent. <p>A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.";
    public static final String BUFFER_MEMORY_CONFIG = "buffer.memory";
    private static final String BUFFER_MEMORY_DOC = "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will either block or throw an exception based on the preference specified by <code>block.on.buffer.full</code>. <p>This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.";
    public static final String ACKS_CONFIG = "acks";
    private static final String ACKS_DOC = "The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the  durability of records that are sent. The following settings are common:  <ul> <li><code>acks=0</code> If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the <code>retries</code> configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to -1. <li><code>acks=1</code> This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. <li><code>acks=all</code> This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee.";
    public static final String TIMEOUT_CONFIG = "timeout.ms";
    private static final String TIMEOUT_DOC = "The configuration controls the maximum amount of time the server will wait for acknowledgments from followers to meet the acknowledgment requirements the producer has specified with the <code>acks</code> configuration. If the requested number of acknowledgments are not met when the timeout elapses an error will be returned. This timeout is measured on the server side and does not include the network latency of the request.";
    public static final String LINGER_MS_CONFIG = "linger.ms";
    private static final String LINGER_MS_DOC = "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay&mdash;that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get <code>batch.size</code> worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting <code>linger.ms=5</code>, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absense of load.";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    public static final String MAX_REQUEST_SIZE_CONFIG = "max.request.size";
    private static final String MAX_REQUEST_SIZE_DOC = "The maximum size of a request. This is also effectively a cap on the maximum record size. Note that the server has its own cap on record size which may be different from this. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    public static final String BLOCK_ON_BUFFER_FULL_CONFIG = "block.on.buffer.full";
    private static final String BLOCK_ON_BUFFER_FULL_DOC = "When our memory buffer is exhausted we must either stop accepting new records (block) or throw errors. By default this setting is true and we block, however in some scenarios blocking is not desirable and it is better to immediately give an error. Setting this to <code>false</code> will accomplish that: the producer will throw a BufferExhaustedException if a recrord is sent and the buffer space is full.";
    public static final String RETRIES_CONFIG = "retries";
    private static final String RETRIES_DOC = "Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error. Note that this retry is no different than if the client resent the record upon receiving the error. Allowing retries will potentially change the ordering of records because if two records are sent to a single partition, and the first fails and is retried but the second succeeds, then the second record may appear first.";
    public static final String RETRY_BACKOFF_MS_CONFIG = "retry.backoff.ms";
    public static final String COMPRESSION_TYPE_CONFIG = "compression.type";
    private static final String COMPRESSION_TYPE_DOC = "The compression type for all data generated by the producer. The default is none (i.e. no compression). Valid  values are <code>none</code>, <code>gzip</code>, <code>snappy</code>, or <code>lz4</code>. Compression is of full batches of data, so the efficacy of batching will also impact the compression ratio (more batching means better compression).";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = "max.in.flight.requests.per.connection";
    private static final String MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DOC = "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).";
    public static final String KEY_SERIALIZER_CLASS_CONFIG = "key.serializer";
    private static final String KEY_SERIALIZER_CLASS_DOC = "Serializer class for key that implements the <code>Serializer</code> interface.";
    public static final String VALUE_SERIALIZER_CLASS_CONFIG = "value.serializer";
    private static final String VALUE_SERIALIZER_CLASS_DOC = "Serializer class for value that implements the <code>Serializer</code> interface.";
    public static final String MARLIN_BUFFER_TIME_CONFIG = "marlin.buffer.max.time.ms";
    private static final String MARLIN_BUFFER_TIME_DOC = "Messages are buffered in the producer at most the specified time.  A thread will flush all messages that have been buffered more than the specified time. The default value is 3000 (3 seconds).";
    public static final String MARLIN_PARALLEL_FLUSHERS_PER_PARTITION_CONFIG = "marlin.parallel.flushers.per.partition";
    private static final String MARLIN_PARALLEL_FLUSHERS_PER_PARTITION_DOC = "This enables parallel flushers per partition.  By default, it is enabled.  If enabled, messages even within a single partition may be delivered out-of-order.";
    public static final String MARLIN_PARTITIONER_CLASS_CONFIG = "marlin.partitioner.class";
    private static final String MARLIN_PARTITIONER_CLASS_DOC = "Marlin's partitioner class that implements <code>MarlinPartitioner</code> interface.";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final String PARTITIONER_CLASS_CONFIG = "partitioner.class";
    private static final String PARTITIONER_CLASS_DOC = "Partitioner class that implements the <code>Partitioner</code> interface.";

    public static Map<String, Object> addSerializerToConfig(Map<String, Object> configs, Serializer<?> keySerializer, Serializer<?> valueSerializer) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        newConfigs.putAll(configs);
        if (keySerializer != null) {
            newConfigs.put(KEY_SERIALIZER_CLASS_CONFIG, keySerializer.getClass());
        }
        if (valueSerializer != null) {
            newConfigs.put(VALUE_SERIALIZER_CLASS_CONFIG, valueSerializer.getClass());
        }
        return newConfigs;
    }

    public static Properties addSerializerToConfig(Properties properties, Serializer<?> keySerializer, Serializer<?> valueSerializer) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        if (keySerializer != null) {
            newProperties.put(KEY_SERIALIZER_CLASS_CONFIG, keySerializer.getClass().getName());
        }
        if (valueSerializer != null) {
            newProperties.put(VALUE_SERIALIZER_CLASS_CONFIG, valueSerializer.getClass().getName());
        }
        return newProperties;
    }

    ProducerConfig(Map<?, ?> props) {
        super(CONFIG, props);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtmlTable());
    }
}

