/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;

public class SubscriptionState {
    private final Set<String> subscribedTopics;
    private final Set<TopicPartition> subscribedPartitions;
    private final Set<TopicPartition> assignedPartitions;
    private final Map<TopicPartition, Long> consumed;
    private final Map<TopicPartition, Long> fetched;
    private final Map<TopicPartition, Long> committed;
    private boolean needsPartitionAssignment;
    private boolean needsFetchCommittedOffsets;
    private Map<TopicPartition, OffsetResetStrategy> resetPartitions;
    private OffsetResetStrategy offsetResetStrategy;

    public SubscriptionState(OffsetResetStrategy offsetResetStrategy) {
        this.offsetResetStrategy = offsetResetStrategy;
        this.subscribedTopics = new HashSet<String>();
        this.subscribedPartitions = new HashSet<TopicPartition>();
        this.assignedPartitions = new HashSet<TopicPartition>();
        this.consumed = new HashMap<TopicPartition, Long>();
        this.fetched = new HashMap<TopicPartition, Long>();
        this.committed = new HashMap<TopicPartition, Long>();
        this.needsPartitionAssignment = false;
        this.needsFetchCommittedOffsets = true;
        this.resetPartitions = new HashMap<TopicPartition, OffsetResetStrategy>();
    }

    public void subscribe(String topic) {
        if (this.subscribedPartitions.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions are mutually exclusive");
        }
        if (!this.subscribedTopics.contains(topic)) {
            this.subscribedTopics.add(topic);
            this.needsPartitionAssignment = true;
        }
    }

    public void unsubscribe(String topic) {
        if (!this.subscribedTopics.contains(topic)) {
            throw new IllegalStateException("Topic " + topic + " was never subscribed to.");
        }
        this.subscribedTopics.remove(topic);
        this.needsPartitionAssignment = true;
        for (TopicPartition tp : this.assignedPartitions()) {
            if (!topic.equals(tp.topic())) continue;
            this.clearPartition(tp);
        }
    }

    public void needReassignment() {
        this.needsPartitionAssignment = true;
    }

    public void subscribe(TopicPartition tp) {
        if (this.subscribedTopics.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions are mutually exclusive");
        }
        this.subscribedPartitions.add(tp);
        this.assignedPartitions.add(tp);
    }

    public void unsubscribe(TopicPartition partition) {
        if (!this.subscribedPartitions.contains(partition)) {
            throw new IllegalStateException("Partition " + partition + " was never subscribed to.");
        }
        this.subscribedPartitions.remove(partition);
        this.clearPartition(partition);
    }

    private void clearPartition(TopicPartition tp) {
        this.assignedPartitions.remove(tp);
        this.committed.remove(tp);
        this.fetched.remove(tp);
        this.consumed.remove(tp);
        this.resetPartitions.remove(tp);
    }

    public void clearAssignment() {
        this.assignedPartitions.clear();
        this.committed.clear();
        this.fetched.clear();
        this.consumed.clear();
        this.needsPartitionAssignment = !this.subscribedTopics().isEmpty();
    }

    public Set<String> subscribedTopics() {
        return this.subscribedTopics;
    }

    public Long fetched(TopicPartition tp) {
        return this.fetched.get(tp);
    }

    public void fetched(TopicPartition tp, long offset) {
        if (!this.assignedPartitions.contains(tp)) {
            throw new IllegalArgumentException("Can't change the fetch position for a partition you are not currently subscribed to.");
        }
        this.fetched.put(tp, offset);
    }

    public void committed(TopicPartition tp, long offset) {
        this.committed.put(tp, offset);
        this.needsFetchCommittedOffsets = false;
    }

    public Long committed(TopicPartition tp) {
        return this.committed.get(tp);
    }

    public void needRefreshCommits() {
        this.needsFetchCommittedOffsets = true;
    }

    public boolean refreshCommitsNeeded() {
        return this.needsFetchCommittedOffsets;
    }

    public void seek(TopicPartition tp, long offset) {
        this.fetched(tp, offset);
        this.consumed(tp, offset);
        this.resetPartitions.remove(tp);
    }

    public Set<TopicPartition> assignedPartitions() {
        return this.assignedPartitions;
    }

    public boolean partitionsAutoAssigned() {
        return !this.subscribedTopics.isEmpty();
    }

    public void consumed(TopicPartition tp, long offset) {
        if (!this.assignedPartitions.contains(tp)) {
            throw new IllegalArgumentException("Can't change the consumed position for a partition you are not currently subscribed to.");
        }
        this.consumed.put(tp, offset);
    }

    public Long consumed(TopicPartition partition) {
        return this.consumed.get(partition);
    }

    public Map<TopicPartition, Long> allConsumed() {
        return this.consumed;
    }

    public void needOffsetReset(TopicPartition partition, OffsetResetStrategy offsetResetStrategy) {
        this.resetPartitions.put(partition, offsetResetStrategy);
        this.fetched.remove(partition);
        this.consumed.remove(partition);
    }

    public void needOffsetReset(TopicPartition partition) {
        this.needOffsetReset(partition, this.offsetResetStrategy);
    }

    public boolean isOffsetResetNeeded(TopicPartition partition) {
        return this.resetPartitions.containsKey(partition);
    }

    public boolean isOffsetResetNeeded() {
        return !this.resetPartitions.isEmpty();
    }

    public OffsetResetStrategy resetStrategy(TopicPartition partition) {
        return this.resetPartitions.get(partition);
    }

    public boolean hasAllFetchPositions() {
        return this.fetched.size() >= this.assignedPartitions.size();
    }

    public Set<TopicPartition> missingFetchPositions() {
        HashSet<TopicPartition> copy = new HashSet<TopicPartition>(this.assignedPartitions);
        copy.removeAll(this.fetched.keySet());
        return copy;
    }

    public boolean partitionAssignmentNeeded() {
        return this.needsPartitionAssignment;
    }

    public void changePartitionAssignment(List<TopicPartition> assignments) {
        for (TopicPartition tp : assignments) {
            if (this.subscribedTopics.contains(tp.topic())) continue;
            throw new IllegalArgumentException("Assigned partition " + tp + " for non-subscribed topic.");
        }
        this.clearAssignment();
        this.assignedPartitions.addAll(assignments);
        this.needsPartitionAssignment = false;
    }
}

