/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

public class RequestFuture<T> {
    public static final RequestFuture<Object> NEED_NEW_COORDINATOR = RequestFuture.newRetryFuture(RetryAction.FIND_COORDINATOR);
    public static final RequestFuture<Object> NEED_POLL = RequestFuture.newRetryFuture(RetryAction.POLL);
    public static final RequestFuture<Object> NEED_METADATA_REFRESH = RequestFuture.newRetryFuture(RetryAction.REFRESH_METADATA);
    private Outcome outcome;
    private RetryAction retryAction;
    private T value;
    private RuntimeException exception;

    public boolean isDone() {
        return this.outcome != null;
    }

    public T value() {
        return this.value;
    }

    public boolean succeeded() {
        return this.outcome == Outcome.SUCCESS;
    }

    public boolean failed() {
        return this.outcome != Outcome.SUCCESS;
    }

    public RetryAction retryAction() {
        return this.retryAction;
    }

    public RuntimeException exception() {
        return this.exception;
    }

    public boolean hasException() {
        return this.outcome == Outcome.EXCEPTION;
    }

    public Outcome outcome() {
        return this.outcome;
    }

    public void retry(RetryAction retryAction) {
        this.outcome = Outcome.NEED_RETRY;
        this.retryAction = retryAction;
    }

    public void retryNow() {
        this.retry(RetryAction.NOOP);
    }

    public void retryAfterBackoff() {
        this.retry(RetryAction.BACKOFF);
    }

    public void retryWithNewCoordinator() {
        this.retry(RetryAction.FIND_COORDINATOR);
    }

    public void retryAfterMetadataRefresh() {
        this.retry(RetryAction.REFRESH_METADATA);
    }

    public void complete(T value) {
        this.outcome = Outcome.SUCCESS;
        this.value = value;
    }

    public void raise(RuntimeException e) {
        this.outcome = Outcome.EXCEPTION;
        this.exception = e;
    }

    private static <T> RequestFuture<T> newRetryFuture(RetryAction retryAction) {
        RequestFuture<T> result = new RequestFuture<T>();
        result.retry(retryAction);
        return result;
    }

    public static <T> RequestFuture<T> pollNeeded() {
        return NEED_POLL;
    }

    public static <T> RequestFuture<T> metadataRefreshNeeded() {
        return NEED_METADATA_REFRESH;
    }

    public static <T> RequestFuture<T> newCoordinatorNeeded() {
        return NEED_NEW_COORDINATOR;
    }

    public static enum Outcome {
        SUCCESS,
        NEED_RETRY,
        EXCEPTION;

    }

    public static enum RetryAction {
        NOOP,
        POLL,
        BACKOFF,
        FIND_COORDINATOR,
        REFRESH_METADATA;

    }
}

