/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

public final class Heartbeat {
    public static final int HEARTBEATS_PER_SESSION_INTERVAL = 3;
    private final long timeout;
    private long lastHeartbeatSend;

    public Heartbeat(long timeout, long now) {
        this.timeout = timeout;
        this.lastHeartbeatSend = now;
    }

    public void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
    }

    public boolean shouldHeartbeat(long now) {
        return (double)(now - this.lastHeartbeatSend) > 0.3333333333333333 * (double)this.timeout;
    }

    public long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    public long timeToNextHeartbeat(long now) {
        long timeSinceLastHeartbeat = now - this.lastHeartbeatSend;
        long hbInterval = this.timeout / 3L;
        if (timeSinceLastHeartbeat > hbInterval) {
            return 0L;
        }
        return hbInterval - timeSinceLastHeartbeat;
    }
}

