/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TProcessor;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSaslTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopThriftAuthBridge {
    public Client createClient() {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public Client createClientWithConf(String authType) {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public UserGroupInformation getCurrentUGIWithConf(String authType) throws IOException {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public String getServerPrincipal(String principalConfig, String host) throws IOException {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public Map<String, String> getHadoopSaslProperties(Configuration conf) {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public static class HiveSaslServerTransportFactory
    extends TSaslServerTransport.Factory {
        private static final Logger LOGGER = LoggerFactory.getLogger(TSaslServerTransport.class);
        private final int saslMessageLimit;
        private static Map<TTransport, WeakReference<TSaslServerTransport>> transportMap = Collections.synchronizedMap(new WeakHashMap());
        private Map<String, TSaslServerDefinition> serverDefinitionMap = new HashMap<String, TSaslServerDefinition>();

        public HiveSaslServerTransportFactory(int saslMessageLimit) {
            this.saslMessageLimit = saslMessageLimit;
        }

        public void addServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.serverDefinitionMap.put(mechanism, new TSaslServerDefinition(mechanism, protocol, serverName, props, cbh));
        }

        public TTransport getTransport(TTransport base) {
            TSaslServerTransport transport;
            WeakReference<TSaslServerTransport> ret = transportMap.get(base);
            TSaslServerTransport tSaslServerTransport = transport = ret == null ? null : (TSaslServerTransport)ret.get();
            if (transport == null) {
                LOGGER.debug("transport map does not contain key {}", (Object)base);
                transport = this.newSaslTransport(base);
                try {
                    transport.open();
                }
                catch (TTransportException e) {
                    LOGGER.debug("failed to open server transport", (Throwable)e);
                    throw new RuntimeException(e);
                }
                transportMap.put(base, new WeakReference<TSaslServerTransport>(transport));
            } else {
                LOGGER.debug("transport map does contain key {}", (Object)base);
            }
            return transport;
        }

        private TSaslServerTransport newSaslTransport(final TTransport base) {
            TSaslServerTransport transport = new TSaslServerTransport(base){
                private final byte[] messageHeader;
                {
                    super(x0);
                    this.messageHeader = new byte[5];
                }

                protected TSaslTransport.SaslResponse receiveSaslMessage() throws TTransportException {
                    this.underlyingTransport.readAll(this.messageHeader, 0, this.messageHeader.length);
                    byte statusByte = this.messageHeader[0];
                    int length = EncodingUtils.decodeBigEndian((byte[])this.messageHeader, (int)1);
                    if (length > HiveSaslServerTransportFactory.this.saslMessageLimit) {
                        base.close();
                        throw new TTransportException("Sasl message is too big (" + length + " bytes). " + "The peer connection is possibly using a protocol other than thrift.");
                    }
                    byte[] payload = new byte[length];
                    this.underlyingTransport.readAll(payload, 0, payload.length);
                    TSaslTransport.NegotiationStatus status = TSaslTransport.NegotiationStatus.byValue((byte)statusByte);
                    if (status == null) {
                        this.sendAndThrowMessage(TSaslTransport.NegotiationStatus.ERROR, "Invalid status " + statusByte);
                    } else if (status == TSaslTransport.NegotiationStatus.BAD || status == TSaslTransport.NegotiationStatus.ERROR) {
                        try {
                            String remoteMessage = new String(payload, "UTF-8");
                            throw new TTransportException("Peer indicated failure: " + remoteMessage);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new TTransportException((Throwable)e);
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(this.getRole() + ": Received message with status {} and payload length {}", (Object)status, (Object)payload.length);
                    }
                    return new TSaslTransport.SaslResponse(status, payload);
                }
            };
            for (Map.Entry<String, TSaslServerDefinition> entry : this.serverDefinitionMap.entrySet()) {
                TSaslServerDefinition definition = entry.getValue();
                transport.addServerDefinition(entry.getKey(), definition.protocol, definition.serverName, definition.props, definition.cbh);
            }
            return transport;
        }

        private static class TSaslServerDefinition {
            public String mechanism;
            public String protocol;
            public String serverName;
            public Map<String, String> props;
            public CallbackHandler cbh;

            public TSaslServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
                this.mechanism = mechanism;
                this.protocol = protocol;
                this.serverName = serverName;
                this.props = props;
                this.cbh = cbh;
            }
        }
    }

    public static abstract class Server {
        public abstract TTransportFactory createTransportFactory(Map<String, String> var1, int var2) throws TTransportException;

        public abstract TProcessor wrapProcessor(TProcessor var1);

        public abstract TProcessor wrapNonAssumingProcessor(TProcessor var1);

        public abstract InetAddress getRemoteAddress();

        public abstract void startDelegationTokenSecretManager(Configuration var1, Object var2) throws IOException;

        public abstract String getDelegationToken(String var1, String var2) throws IOException, InterruptedException;

        public abstract String getDelegationTokenWithService(String var1, String var2, String var3) throws IOException, InterruptedException;

        public abstract String getRemoteUser();

        public abstract long renewDelegationToken(String var1) throws IOException;

        public abstract void cancelDelegationToken(String var1) throws IOException;

        public abstract String getUserFromToken(String var1) throws IOException;

        public abstract void addServerDefinition(TTransportFactory var1, String var2, String var3, String var4, Map<String, String> var5, CallbackHandler var6);
    }

    public static abstract class Client {
        public abstract TTransport createClientTransport(String var1, String var2, String var3, String var4, TTransport var5, Map<String, String> var6) throws IOException;
    }
}

