/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;

public class RpcAuthMethodHelper {
    static final Log LOG = LogFactory.getLog(RpcAuthMethodHelper.class);

    public static CallbackHandler createCallbackHandler() {
        try {
            AccessControlContext e = AccessController.getContext();
            Subject subject = Subject.getSubject(e);
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            String className = "com.mapr.security.callback.MaprSaslCallbackHandler";
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(Subject.class, String.class);
            return (CallbackHandler)ctor.newInstance(subject, current.getShortUserName());
        }
        catch (Exception var4) {
            LOG.error((Object)"Creating MaprSaslCallbackhandler Error.", (Throwable)var4);
            return null;
        }
    }

    public static List<String> getRpcAuthMethodList(UserGroupInformation realUgi) {
        ArrayList<String> rpcAuthMethodList = new ArrayList<String>();
        try {
            Class<UserGroupInformation> clazz = UserGroupInformation.class;
            String methodName = "getRpcAuthMethodList";
            Method method = clazz.getMethod(methodName, new Class[0]);
            List objects = (List)method.invoke((Object)realUgi, new Object[0]);
            methodName = "getMechanismName";
            for (Object object : objects) {
                method = object.getClass().getMethod(methodName, new Class[0]);
                String rpcAuthMethod = (String)method.invoke(object, new Object[0]);
                rpcAuthMethodList.add(rpcAuthMethod);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return rpcAuthMethodList;
    }

    public static enum AuthMethod {
        MAPRSASL;


        public String getMechanismName() {
            try {
                String className = "org.apache.hadoop.security.rpcauth.MaprAuthMethod";
                String methodName = "getMechanismName";
                Class<?> clazz = Class.forName(className);
                Field field = clazz.getDeclaredField("INSTANCE");
                field.setAccessible(true);
                Object maprAuthMethod = field.get(null);
                Method method = maprAuthMethod.getClass().getMethod(methodName, new Class[0]);
                return (String)method.invoke(maprAuthMethod, new Object[0]);
            }
            catch (Exception e) {
                LOG.error((Object)"Creating MaprAuthMethod Error.", (Throwable)e);
                return "";
            }
        }
    }
}

