/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge20S;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.transport.TTransportException;

public class HadoopThriftAuthBridge23
extends HadoopThriftAuthBridge20S {
    private static Field SASL_PROPS_FIELD;
    private static Class<?> SASL_PROPERTIES_RESOLVER_CLASS;
    private static Method RES_GET_INSTANCE_METHOD;
    private static Method GET_PROP_METHOD;

    public Map<String, String> getHadoopSaslProperties(Configuration conf) {
        if (SASL_PROPS_FIELD != null) {
            SaslRpcServer.init((Configuration)conf);
            try {
                return (Map)SASL_PROPS_FIELD.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error finding hadoop SASL properties", e);
            }
        }
        try {
            Configurable saslPropertiesResolver = (Configurable)RES_GET_INSTANCE_METHOD.invoke(null, conf);
            saslPropertiesResolver.setConf(conf);
            return (Map)GET_PROP_METHOD.invoke((Object)saslPropertiesResolver, InetAddress.getLocalHost());
        }
        catch (Exception e) {
            throw new IllegalStateException("Error finding hadoop SASL properties", e);
        }
    }

    public HadoopThriftAuthBridge20S.Server createServer(String keytabFile, String principalConf) throws TTransportException {
        if (keytabFile.isEmpty() || principalConf.isEmpty()) {
            return new HadoopThriftAuthBridge20S.Server();
        }
        return new HadoopThriftAuthBridge20S.Server(keytabFile, principalConf);
    }

    public HadoopThriftAuthBridge20S.Client createClientWithConf(String authType) {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authType);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new HadoopThriftAuthBridge20S.Client();
    }

    static {
        SASL_PROPERTIES_RESOLVER_CLASS = null;
        SASL_PROPS_FIELD = null;
        String SASL_PROP_RES_CLASSNAME = "org.apache.hadoop.security.SaslPropertiesResolver";
        try {
            SASL_PROPERTIES_RESOLVER_CLASS = Class.forName("org.apache.hadoop.security.SaslPropertiesResolver");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (SASL_PROPERTIES_RESOLVER_CLASS != null) {
            try {
                RES_GET_INSTANCE_METHOD = SASL_PROPERTIES_RESOLVER_CLASS.getMethod("getInstance", Configuration.class);
                GET_PROP_METHOD = SASL_PROPERTIES_RESOLVER_CLASS.getMethod("getServerProperties", InetAddress.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (SASL_PROPERTIES_RESOLVER_CLASS == null) {
            try {
                SASL_PROPS_FIELD = SaslRpcServer.class.getField("SASL_PROPS");
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Error finding hadoop SASL_PROPS field in " + SaslRpcServer.class.getSimpleName(), e);
            }
        }
    }
}

