/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge20S;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge23;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.security.token.Token;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HadoopThriftAuthBridge25Sasl
extends HadoopThriftAuthBridge23 {
    static final Log LOG = LogFactory.getLog(HadoopThriftAuthBridge25Sasl.class);

    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        if (keytabFile.isEmpty() || principalConf.isEmpty()) {
            return new Server();
        }
        return new Server(keytabFile, principalConf);
    }

    public Client createClientWithConf(String authType) {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authType);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    public Client createClient() {
        return new Client();
    }

    public static class Client
    extends HadoopThriftAuthBridge20S.Client {
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            UserGroupInformation.AuthenticationMethod authenticationMethod = ugi.getAuthenticationMethod();
            TSaslClientTransport saslTransport = null;
            LOG.info((Object)("Sasl client AuthenticationMethod: " + authenticationMethod.toString()));
            if (authenticationMethod.equals((Object)UserGroupInformation.AuthenticationMethod.PROXY)) {
                SaslRpcServer.AuthMethod method;
                if (methodStr != null && (method = (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.valueOf(SaslRpcServer.AuthMethod.class, (String)methodStr)) == SaslRpcServer.AuthMethod.DIGEST) {
                    Token t = new Token();
                    t.decodeFromUrlString(tokenStrForm);
                    saslTransport = new TSaslClientTransport(method.getMechanismName(), null, null, "default", saslProps, (CallbackHandler)new HadoopThriftAuthBridge20S.Client.SaslClientCallbackHandler(t), underlyingTransport);
                    return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
                }
                throw new IOException("Unsupported authentication method: PROXY-" + methodStr);
            }
            RpcAuthMethod rpcAuthMethod = RpcAuthRegistry.getAuthMethod((UserGroupInformation.AuthenticationMethod)ugi.getAuthenticationMethod());
            if (rpcAuthMethod == null) {
                throw new IOException("Unsupported authentication method: " + ugi.getAuthenticationMethod());
            }
            if (authenticationMethod.equals((Object)UserGroupInformation.AuthenticationMethod.TOKEN)) {
                Token t = new Token();
                t.decodeFromUrlString(tokenStrForm);
                saslTransport = new TSaslClientTransport(rpcAuthMethod.getMechanismName(), null, null, "default", saslProps, (CallbackHandler)new HadoopThriftAuthBridge20S.Client.SaslClientCallbackHandler(t), underlyingTransport);
                return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
            }
            if (authenticationMethod.equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
                String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
                if (names.length != 3) {
                    throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                }
                try {
                    saslTransport = new TSaslClientTransport(rpcAuthMethod.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
                    return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
                }
                catch (SaslException se) {
                    throw new IOException("Could not instantiate SASL transport", se);
                }
            }
            try {
                saslTransport = new TSaslClientTransport(rpcAuthMethod.getMechanismName(), null, null, "default", saslProps, null, underlyingTransport);
                return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
            }
            catch (SaslException se) {
                throw new IOException("Could not instantiate SASL transport", se);
            }
        }
    }

    public static class Server
    extends HadoopThriftAuthBridge20S.Server {
        public Server() throws TTransportException {
        }

        protected Server(String keytabFile, String principalConf) throws TTransportException {
            super(keytabFile, principalConf);
        }

        public TTransportFactory createTransportFactory(Map<String, String> saslProps, int saslMessageLimit) throws TTransportException {
            List rpcAuthMethods = this.realUgi.getRpcAuthMethodList();
            Object transFactory = saslMessageLimit > 0 ? new HadoopThriftAuthBridge.HiveSaslServerTransportFactory(saslMessageLimit) : new TSaslServerTransport.Factory();
            for (RpcAuthMethod rpcAuthMethod : rpcAuthMethods) {
                if (rpcAuthMethod.getAuthenticationMethod().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                    String kerberosName = this.realUgi.getUserName();
                    String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
                    if (names.length != 3) continue;
                    transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), names[0], names[1], saslProps, rpcAuthMethod.createCallbackHandler());
                    continue;
                }
                transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), null, "default", saslProps, rpcAuthMethod.createCallbackHandler());
            }
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, (CallbackHandler)new HadoopThriftAuthBridge20S.Server.SaslDigestCallbackHandler(this.secretManager));
            return new HadoopThriftAuthBridge20S.Server.TUGIAssumingTransportFactory((TTransportFactory)transFactory, this.realUgi);
        }
    }
}

