/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.testutils.junit.runners;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.testutils.junit.runners.model.ConcurrentScheduler;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class ConcurrentTestRunner
extends BlockJUnit4ClassRunner {
    private int numThreads = 1;

    public ConcurrentTestRunner(Class<?> type) throws InitializationError {
        super(type);
        String numThreadsProp = System.getProperty("test.concurrency.num.threads");
        if (numThreadsProp != null) {
            this.numThreads = Integer.valueOf(numThreadsProp);
        }
        this.setScheduler(new ConcurrentScheduler(Executors.newFixedThreadPool(this.numThreads, new ConcurrentTestRunnerThreadFactory())));
        System.err.println(">>> ConcurrenTestRunner initialize with " + this.numThreads + " threads");
        System.err.flush();
    }

    private static class ConcurrentTestRunnerThreadFactory
    implements ThreadFactory {
        private final AtomicLong count = new AtomicLong();

        private ConcurrentTestRunnerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = ConcurrentTestRunner.class.getSimpleName() + "-Thread-" + this.count.getAndIncrement();
            System.err.println(">>> ConcurrentTestRunner.newThread " + threadName);
            System.err.flush();
            return new Thread(runnable, threadName);
        }
    }
}

