/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;

public class Hadoop20SShims
extends HadoopShimsSecure {
    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return TaskLogServlet.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerState()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerState();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContext(conf, new TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public JobContext newJobContext(Job job) {
        return new JobContext(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        return "local".equals(this.getJobLauncherRpcAddress(conf));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("mapred.job.tracker");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        conf.set("mapred.job.tracker", val);
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("mapred.job.tracker.http.address");
    }

    @Override
    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        Configuration dupConf = new Configuration(conf);
        FileSystem.setDefaultUri((Configuration)dupConf, (URI)fs.getUri());
        Trash trash = new Trash(dupConf);
        return trash.moveToTrash(path);
    }

    @Override
    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication();
    }

    @Override
    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            return this.mr.getJobTrackerPort();
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Hadoop20SShims.this.setJobLauncherRpcAddress(conf, "localhost:" + this.mr.getJobTrackerPort());
        }
    }
}

