/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.server.HiveServer2;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHS2HttpServer {
    private static HiveServer2 hiveServer2 = null;

    @BeforeClass
    public static void beforeTests() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, false);
        hiveServer2 = new HiveServer2();
        hiveServer2.init(hiveConf);
        hiveServer2.start();
        Thread.sleep(5000L);
    }

    @Test
    public void testStackServket() throws Exception {
        String line;
        String baseURL = "http://localhost:" + HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue() + "/stacks";
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        boolean contents = false;
        while ((line = reader.readLine()) != null) {
            if (!line.contains("Process Thread Dump:")) continue;
            contents = true;
        }
        Assert.assertTrue((boolean)contents);
    }

    @AfterClass
    public static void afterTests() throws Exception {
        hiveServer2.stop();
    }
}

