/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.File;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.server.HiveServer2;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSessionManagerMetrics {
    private static SessionManager sm;
    private static File jsonReportFile;
    final Object barrier = new Object();

    @BeforeClass
    public static void setup() throws Exception {
        HiveConf conf = new HiveConf();
        conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS, 2);
        conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE, 10);
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME, "1000000s");
        File workDir = new File(System.getProperty("test.tmp.dir"));
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, MetricsReporting.JSON_FILE.name() + "," + MetricsReporting.JMX.name());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION, jsonReportFile.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100ms");
        MetricsFactory.init((HiveConf)conf);
        HiveServer2 hs2 = new HiveServer2();
        sm = new SessionManager(hs2);
        sm.init(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadPoolMetrics() throws Exception {
        sm.submitBackgroundOperation((Runnable)new BarrierRunnable());
        sm.submitBackgroundOperation((Runnable)new BarrierRunnable());
        sm.submitBackgroundOperation((Runnable)new BarrierRunnable());
        sm.submitBackgroundOperation((Runnable)new BarrierRunnable());
        Thread.sleep(2000L);
        MetricsTestUtils.verifyMetricFile((File)jsonReportFile, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_pool_size", (Object)2);
        MetricsTestUtils.verifyMetricFile((File)jsonReportFile, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_queue_size", (Object)2);
        Object object = this.barrier;
        synchronized (object) {
            this.barrier.notifyAll();
        }
        Thread.sleep(2000L);
        MetricsTestUtils.verifyMetricFile((File)jsonReportFile, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_pool_size", (Object)2);
        MetricsTestUtils.verifyMetricFile((File)jsonReportFile, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_queue_size", (Object)0);
    }

    class BarrierRunnable
    implements Runnable {
        BarrierRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = TestSessionManagerMetrics.this.barrier;
            synchronized (object) {
                try {
                    TestSessionManagerMetrics.this.barrier.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

