/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.junit.Before;
import org.junit.Test;

public class TestPluggableHiveSessionImpl
extends TestCase {
    private HiveConf hiveConf;
    private CLIService cliService;
    private ThriftCLIServiceClient client;
    private ThriftCLIService service;

    @Before
    public void setUp() {
        this.hiveConf = new HiveConf();
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_CLASSNAME, TestHiveSessionImpl.class.getName());
        this.cliService = new CLIService(null);
        this.service = new ThriftBinaryCLIService(this.cliService, null);
        this.service.init(this.hiveConf);
        this.client = new ThriftCLIServiceClient((TCLIService.Iface)this.service);
    }

    @Test
    public void testSessionImpl() {
        SessionHandle sessionHandle = null;
        try {
            sessionHandle = this.client.openSession("tom", "password");
            Assert.assertEquals((String)TestHiveSessionImpl.class.getName(), (String)this.service.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_CLASSNAME));
            Assert.assertTrue((boolean)(this.cliService.getSessionManager().getSession(sessionHandle) instanceof TestHiveSessionImpl));
            this.client.closeSession(sessionHandle);
        }
        catch (HiveSQLException e) {
            e.printStackTrace();
        }
    }

    class TestHiveSessionImpl
    extends HiveSessionImpl {
        public TestHiveSessionImpl(TProtocolVersion protocol, String username, String password, HiveConf serverhiveConf, String ipAddress) {
            super(protocol, username, password, serverhiveConf, ipAddress);
        }
    }
}

