/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.RetryingThriftCLIServiceClient;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.HiveServer2;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Test;

public class TestRetryingThriftCLIServiceClient {
    protected static ThriftCLIService service;

    @Test
    public void testRetryBehaviour() throws Exception {
        CLIServiceClient cliServiceClient;
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, "localhost");
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 15000);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION, HiveAuthFactory.AuthTypes.NONE.toString());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE, "binary");
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_RETRY_LIMIT, 3);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 3);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS, 10);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT, "1s");
        HiveServer2 server = new HiveServer2();
        server.init(hiveConf);
        server.start();
        Thread.sleep(5000L);
        System.out.println("## HiveServer started");
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 17000);
        try {
            cliServiceClient = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
            Assert.fail((String)"Expected to throw exception for invalid port");
        }
        catch (HiveSQLException sqlExc) {
            Assert.assertTrue((boolean)(sqlExc.getCause() instanceof TTransportException));
            Assert.assertTrue((boolean)sqlExc.getMessage().contains("3"));
        }
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 15000);
        cliServiceClient = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
        System.out.println("## Created client");
        server.stop();
        Thread.sleep(5000L);
        try {
            HashMap confOverlay = new HashMap();
            RetryingThriftCLIServiceClientTest.handlerInst.callCount = 0;
            RetryingThriftCLIServiceClientTest.handlerInst.connectCount = 0;
            SessionHandle session = cliServiceClient.openSession("anonymous", "anonymous");
        }
        catch (HiveSQLException exc) {
            exc.printStackTrace();
            Assert.assertTrue((boolean)(exc.getCause() instanceof TException));
            Assert.assertEquals((long)1L, (long)RetryingThriftCLIServiceClientTest.handlerInst.callCount);
            Assert.assertEquals((long)3L, (long)RetryingThriftCLIServiceClientTest.handlerInst.connectCount);
        }
    }

    static class RetryingThriftCLIServiceClientTest
    extends RetryingThriftCLIServiceClient {
        int callCount = 0;
        int connectCount = 0;
        static RetryingThriftCLIServiceClientTest handlerInst;

        protected RetryingThriftCLIServiceClientTest(HiveConf conf) {
            super(conf);
        }

        public static CLIServiceClient newRetryingCLIServiceClient(HiveConf conf) throws HiveSQLException {
            handlerInst = new RetryingThriftCLIServiceClientTest(conf);
            handlerInst.connectWithRetry(conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_RETRY_LIMIT));
            ICLIService cliService = (ICLIService)Proxy.newProxyInstance(RetryingThriftCLIServiceClientTest.class.getClassLoader(), CLIServiceClient.class.getInterfaces(), (InvocationHandler)((Object)handlerInst));
            return new RetryingThriftCLIServiceClient.CLIServiceClientWrapper(cliService);
        }

        protected RetryingThriftCLIServiceClient.InvocationResult invokeInternal(Method method, Object[] args) throws Throwable {
            System.out.println("## Calling: " + method.getName() + ", " + this.callCount + "/" + this.getRetryLimit());
            ++this.callCount;
            return super.invokeInternal(method, args);
        }

        protected synchronized TTransport connect(HiveConf conf) throws HiveSQLException, TTransportException {
            ++this.connectCount;
            return super.connect(conf);
        }
    }
}

