/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.service.cli.Column;
import org.apache.hive.service.cli.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestColumn {
    @Test
    public void testAllIntegerTypeValues() {
        LinkedHashMap<Type, List<Object>> integerTypesAndValues = new LinkedHashMap<Type, List<Object>>();
        integerTypesAndValues.put(Type.TINYINT_TYPE, Arrays.asList((byte)-128, (byte)127));
        integerTypesAndValues.put(Type.SMALLINT_TYPE, Arrays.asList((short)Short.MIN_VALUE, (short)Short.MIN_VALUE));
        integerTypesAndValues.put(Type.INT_TYPE, Arrays.asList(Integer.MIN_VALUE, Integer.MAX_VALUE));
        integerTypesAndValues.put(Type.BIGINT_TYPE, Arrays.asList(Long.MIN_VALUE, Long.MAX_VALUE));
        for (Map.Entry entry : integerTypesAndValues.entrySet()) {
            Type type = (Type)entry.getKey();
            List values = (List)entry.getValue();
            Column c = new Column(type);
            for (Object v : values) {
                c.addValue(type, v);
            }
            Assert.assertEquals((Object)type, (Object)c.getType());
            Assert.assertEquals((long)values.size(), (long)c.size());
            for (int i = 0; i < c.size(); ++i) {
                Assert.assertEquals(values.get(i), (Object)c.get(i));
            }
        }
    }

    @Test
    public void testFloatAndDoubleValues() {
        Column floatColumn = new Column(Type.FLOAT_TYPE);
        floatColumn.addValue(Type.FLOAT_TYPE, (Object)Float.valueOf(1.1f));
        floatColumn.addValue(Type.FLOAT_TYPE, (Object)Float.valueOf(2.033f));
        Assert.assertEquals((Object)Type.DOUBLE_TYPE, (Object)floatColumn.getType());
        Assert.assertEquals((long)2L, (long)floatColumn.size());
        Assert.assertEquals((Object)1.1, (Object)floatColumn.get(0));
        Assert.assertEquals((Object)2.033, (Object)floatColumn.get(1));
        Column doubleColumn = new Column(Type.DOUBLE_TYPE);
        doubleColumn.addValue(Type.DOUBLE_TYPE, (Object)1.1);
        doubleColumn.addValue(Type.DOUBLE_TYPE, (Object)2.033);
        Assert.assertEquals((Object)Type.DOUBLE_TYPE, (Object)doubleColumn.getType());
        Assert.assertEquals((long)2L, (long)doubleColumn.size());
        Assert.assertEquals((Object)1.1, (Object)doubleColumn.get(0));
        Assert.assertEquals((Object)2.033, (Object)doubleColumn.get(1));
    }

    @Test
    public void testBooleanValues() {
        Column boolColumn = new Column(Type.BOOLEAN_TYPE);
        boolColumn.addValue(Type.BOOLEAN_TYPE, (Object)true);
        boolColumn.addValue(Type.BOOLEAN_TYPE, (Object)false);
        Assert.assertEquals((Object)Type.BOOLEAN_TYPE, (Object)boolColumn.getType());
        Assert.assertEquals((long)2L, (long)boolColumn.size());
        Assert.assertEquals((Object)true, (Object)boolColumn.get(0));
        Assert.assertEquals((Object)false, (Object)boolColumn.get(1));
    }

    @Test
    public void testStringValues() {
        Column stringColumn = new Column(Type.STRING_TYPE);
        stringColumn.addValue(Type.STRING_TYPE, (Object)"12abc456");
        stringColumn.addValue(Type.STRING_TYPE, (Object)"~special$&string");
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)stringColumn.getType());
        Assert.assertEquals((long)2L, (long)stringColumn.size());
        Assert.assertEquals((Object)"12abc456", (Object)stringColumn.get(0));
        Assert.assertEquals((Object)"~special$&string", (Object)stringColumn.get(1));
    }

    @Test
    public void testBinaryValues() {
        Column binaryColumn = new Column(Type.BINARY_TYPE);
        binaryColumn.addValue(Type.BINARY_TYPE, (Object)new byte[]{-1, 0, 3, 4});
        Assert.assertEquals((Object)Type.BINARY_TYPE, (Object)binaryColumn.getType());
        Assert.assertEquals((long)1L, (long)binaryColumn.size());
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, 3, 4}, (byte[])((byte[])binaryColumn.get(0)));
    }
}

