/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.Type;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CLIServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(CLIServiceTest.class);
    protected static CLIServiceClient client;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOpenSession() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", Collections.emptyMap());
        Assert.assertNotNull((Object)sessionHandle);
        client.closeSession(sessionHandle);
        sessionHandle = client.openSession("tom", "password");
        Assert.assertNotNull((Object)sessionHandle);
        client.closeSession(sessionHandle);
    }

    @Test
    public void testGetFunctions() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password");
        Assert.assertNotNull((Object)sessionHandle);
        OperationHandle opHandle = client.getFunctions(sessionHandle, null, null, "*");
        TableSchema schema = client.getResultSetMetadata(opHandle);
        ColumnDescriptor columnDesc = schema.getColumnDescriptorAt(0);
        Assert.assertEquals((Object)"FUNCTION_CAT", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(1);
        Assert.assertEquals((Object)"FUNCTION_SCHEM", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(2);
        Assert.assertEquals((Object)"FUNCTION_NAME", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(3);
        Assert.assertEquals((Object)"REMARKS", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(4);
        Assert.assertEquals((Object)"FUNCTION_TYPE", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.INT_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(5);
        Assert.assertEquals((Object)"SPECIFIC_NAME", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        client.closeOperation(opHandle);
        client.closeSession(sessionHandle);
    }

    @Test
    public void testGetInfo() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", Collections.emptyMap());
        Assert.assertNotNull((Object)sessionHandle);
        GetInfoValue value = client.getInfo(sessionHandle, GetInfoType.CLI_DBMS_NAME);
        System.out.println(value.getStringValue());
        value = client.getInfo(sessionHandle, GetInfoType.CLI_SERVER_NAME);
        System.out.println(value.getStringValue());
        value = client.getInfo(sessionHandle, GetInfoType.CLI_DBMS_VER);
        System.out.println(value.getStringValue());
        client.closeSession(sessionHandle);
    }

    @Test
    public void testExecuteStatement() throws Exception {
        HashMap confOverlay = new HashMap();
        SessionHandle sessionHandle = client.openSession("tom", "password", new HashMap());
        Assert.assertNotNull((Object)sessionHandle);
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        queryString = "CREATE TABLE TEST_EXEC(ID STRING)";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        queryString = "SELECT ID+1 FROM TEST_EXEC";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        client.closeSession(sessionHandle);
    }

    @Test
    public void testExecuteStatementAsync() throws Exception {
        HashMap<String, String> confOverlay = new HashMap<String, String>();
        String tableName = "TEST_EXEC_ASYNC";
        String columnDefinitions = "(ID STRING)";
        SessionHandle sessionHandle = this.setupTestData(tableName, columnDefinitions, confOverlay);
        Assert.assertNotNull((Object)sessionHandle);
        OperationState state = null;
        OperationStatus opStatus = null;
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        long longPollingTimeout = HiveConf.getTimeVar((Configuration)new HiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        queryString = "SELECT NON_EXISTING_COLUMN FROM " + tableName;
        try {
            this.runAsyncAndWait(sessionHandle, queryString, confOverlay, OperationState.ERROR, longPollingTimeout);
        }
        catch (HiveSQLException e) {
            // empty catch block
        }
        queryString = "CREATE TABLE NON_EXISTING_TAB (ID STRING) location 'invalid://localhost:10000/a/b/c'";
        opStatus = this.runAsyncAndWait(sessionHandle, queryString, confOverlay, OperationState.ERROR, longPollingTimeout);
        Assert.assertEquals((Object)opStatus.getOperationException().getSQLState(), (Object)"08S01");
        Assert.assertEquals((long)opStatus.getOperationException().getErrorCode(), (long)1L);
        queryString = "SELECT ID+1 FROM " + tableName;
        this.runAsyncAndWait(sessionHandle, queryString, confOverlay, OperationState.FINISHED, longPollingTimeout);
        longPollingTimeout = 0L;
        queryString = "SELECT ID+1 FROM " + tableName;
        this.runAsyncAndWait(sessionHandle, queryString, confOverlay, OperationState.FINISHED, longPollingTimeout);
        longPollingTimeout = 500L;
        queryString = "SELECT ID+1 FROM " + tableName;
        this.runAsyncAndWait(sessionHandle, queryString, confOverlay, OperationState.FINISHED, longPollingTimeout);
        queryString = "SELECT ID+1 FROM " + tableName;
        opHandle = client.executeStatementAsync(sessionHandle, queryString, confOverlay);
        System.out.println("Cancelling " + opHandle);
        client.cancelOperation(opHandle);
        state = client.getOperationStatus(opHandle).getState();
        System.out.println(opHandle + " after cancelling, state= " + state);
        Assert.assertEquals((String)"Query should be cancelled", (Object)OperationState.CANCELED, (Object)state);
        queryString = "DROP TABLE " + tableName;
        client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeSession(sessionHandle);
    }

    private void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testExecuteStatementParallel() throws Exception {
        int i;
        HashMap<String, String> confOverlay = new HashMap<String, String>();
        String tableName = "TEST_EXEC_PARALLEL";
        String columnDefinitions = "(ID STRING)";
        SessionHandle sessionHandle = this.setupTestData(tableName, columnDefinitions, confOverlay);
        Assert.assertNotNull((Object)sessionHandle);
        long longPollingTimeout = HiveConf.getTimeVar((Configuration)new HiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        confOverlay.put(HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT.varname, longPollingTimeout + "ms");
        int THREAD_COUNT = 10;
        int QUERY_COUNT = 10;
        ExecutorService executor = Executors.newFixedThreadPool(THREAD_COUNT);
        CountDownLatch cdlIn = new CountDownLatch(THREAD_COUNT);
        CountDownLatch cdlOut = new CountDownLatch(1);
        Callable[] cs = new Callable[3];
        String query = "SELECT ID + %1$d FROM " + tableName;
        cs[0] = this.createQueryCallable(query, confOverlay, longPollingTimeout, QUERY_COUNT, cdlIn, cdlOut);
        query = "SELECT t1.ID, SUM(t2.ID) + %1$d FROM  " + tableName + " t1 CROSS JOIN " + tableName + " t2 GROUP BY t1.ID HAVING t1.ID > 1";
        cs[1] = this.createQueryCallable(query, confOverlay, longPollingTimeout, QUERY_COUNT, cdlIn, cdlOut);
        query = "SELECT b.a FROM (SELECT (t1.ID + %1$d) as a , t2.* FROM  " + tableName + " t1 INNER JOIN " + tableName + " t2 ON t1.ID = t2.ID WHERE t2.ID > 2) b";
        cs[2] = this.createQueryCallable(query, confOverlay, longPollingTimeout, QUERY_COUNT, cdlIn, cdlOut);
        FutureTask[] tasks = new FutureTask[THREAD_COUNT];
        for (i = 0; i < THREAD_COUNT; ++i) {
            tasks[i] = new FutureTask(cs[i % cs.length]);
            executor.execute(tasks[i]);
        }
        try {
            cdlIn.await();
            cdlOut.countDown();
            for (i = 0; i < THREAD_COUNT; ++i) {
                tasks[i].get();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        client.executeStatement(sessionHandle, "DROP TABLE " + tableName, confOverlay);
        client.closeSession(sessionHandle);
    }

    private Callable<Void> createQueryCallable(final String queryStringFormat, final Map<String, String> confOverlay, final long longPollingTimeout, final int queryCount, final CountDownLatch cdlIn, final CountDownLatch cdlOut) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int i;
                CLIServiceTest.this.syncThreadStart(cdlIn, cdlOut);
                SessionHandle sessionHandle = CLIServiceTest.this.openSession(confOverlay);
                OperationHandle[] hs = new OperationHandle[queryCount];
                for (i = 0; i < hs.length; ++i) {
                    String queryString = String.format(queryStringFormat, i);
                    LOG.info("Submitting " + i);
                    hs[i] = client.executeStatementAsync(sessionHandle, queryString, confOverlay);
                }
                for (i = hs.length - 1; i >= 0; --i) {
                    CLIServiceTest.this.waitForAsyncQuery(hs[i], OperationState.FINISHED, longPollingTimeout);
                }
                return null;
            }
        };
    }

    private SessionHandle setupTestData(String tableName, String columnDefinitions, Map<String, String> confOverlay) throws Exception {
        SessionHandle sessionHandle = this.openSession(confOverlay);
        this.createTestTable(tableName, columnDefinitions, confOverlay, sessionHandle);
        return sessionHandle;
    }

    private SessionHandle openSession(Map<String, String> confOverlay) throws HiveSQLException {
        SessionHandle sessionHandle = client.openSession("tom", "password", confOverlay);
        Assert.assertNotNull((Object)sessionHandle);
        SessionState.get().setIsHiveServerQuery(true);
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        client.executeStatement(sessionHandle, queryString, confOverlay);
        return sessionHandle;
    }

    private void createTestTable(String tableName, String columnDefinitions, Map<String, String> confOverlay, SessionHandle sessionHandle) throws HiveSQLException {
        String queryString = "DROP TABLE IF EXISTS " + tableName;
        client.executeStatement(sessionHandle, queryString, confOverlay);
        queryString = "CREATE TABLE " + tableName + columnDefinitions;
        client.executeStatement(sessionHandle, queryString, confOverlay);
    }

    private OperationStatus runAsyncAndWait(SessionHandle sessionHandle, String queryString, Map<String, String> confOverlay, OperationState expectedState, long longPollingTimeout) throws HiveSQLException {
        confOverlay.put(HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT.varname, longPollingTimeout + "ms");
        OperationHandle h = client.executeStatementAsync(sessionHandle, queryString, confOverlay);
        return this.waitForAsyncQuery(h, expectedState, longPollingTimeout);
    }

    private OperationStatus waitForAsyncQuery(OperationHandle opHandle, OperationState expectedState, long longPollingTimeout) throws HiveSQLException {
        long testIterationTimeout = System.currentTimeMillis() + 100000L;
        OperationStatus opStatus = null;
        OperationState state = null;
        int count = 0;
        while (true) {
            if (System.currentTimeMillis() > testIterationTimeout) {
                System.out.println("Polling timed out");
                break;
            }
            long longPollingStart = System.currentTimeMillis();
            System.out.println("Long polling starts at: " + longPollingStart);
            opStatus = client.getOperationStatus(opHandle);
            state = opStatus.getState();
            long longPollingEnd = System.currentTimeMillis();
            System.out.println("Long polling ends at: " + longPollingEnd);
            System.out.println("Polling: " + opHandle + " count=" + ++count + " state=" + state);
            if (state == OperationState.CANCELED || state == OperationState.CLOSED || state == OperationState.FINISHED || state == OperationState.ERROR) break;
            long longPollingTimeDelta = longPollingEnd - longPollingStart;
            Assert.assertTrue(((double)longPollingTimeDelta - 0.9 * (double)longPollingTimeout > 0.0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)expectedState, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        return opStatus;
    }

    @Test
    public void testConfOverlay() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", new HashMap());
        Assert.assertNotNull((Object)sessionHandle);
        String tabName = "TEST_CONF_EXEC";
        String tabNameVar = "tabNameVar";
        String setLockMgr = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(sessionHandle, setLockMgr, null);
        client.closeOperation(opHandle);
        String dropTable = "DROP TABLE IF EXISTS " + tabName;
        opHandle = client.executeStatement(sessionHandle, dropTable, null);
        client.closeOperation(opHandle);
        HashMap<String, String> confOverlay = new HashMap<String, String>();
        confOverlay.put(tabNameVar, tabName);
        String createTab = "CREATE TABLE ${hiveconf:" + tabNameVar + "} (id int)";
        opHandle = client.executeStatement(sessionHandle, createTab, confOverlay);
        Assert.assertNotNull((Object)opHandle);
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        String selectTab = "SELECT * FROM " + tabName;
        opHandle = client.executeStatement(sessionHandle, selectTab, null);
        Assert.assertNotNull((Object)opHandle);
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        selectTab = "SELECT * FROM ${hiveconf:" + tabNameVar + "}";
        try {
            opHandle = client.executeStatement(sessionHandle, selectTab, null);
            Assert.fail((String)"Query should fail");
        }
        catch (HiveSQLException e) {
            // empty catch block
        }
        dropTable = "DROP TABLE IF EXISTS " + tabName;
        opHandle = client.executeStatement(sessionHandle, dropTable, null);
        client.closeOperation(opHandle);
        client.closeSession(sessionHandle);
    }
}

