/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.Type;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class CLIServiceTest {
    protected static CLIServiceClient client;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOpenSession() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", Collections.emptyMap());
        Assert.assertNotNull((Object)sessionHandle);
        client.closeSession(sessionHandle);
        sessionHandle = client.openSession("tom", "password");
        Assert.assertNotNull((Object)sessionHandle);
        client.closeSession(sessionHandle);
    }

    @Test
    public void testGetFunctions() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password");
        Assert.assertNotNull((Object)sessionHandle);
        OperationHandle opHandle = client.getFunctions(sessionHandle, null, null, "*");
        TableSchema schema = client.getResultSetMetadata(opHandle);
        ColumnDescriptor columnDesc = schema.getColumnDescriptorAt(0);
        Assert.assertEquals((Object)"FUNCTION_CAT", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(1);
        Assert.assertEquals((Object)"FUNCTION_SCHEM", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(2);
        Assert.assertEquals((Object)"FUNCTION_NAME", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(3);
        Assert.assertEquals((Object)"REMARKS", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(4);
        Assert.assertEquals((Object)"FUNCTION_TYPE", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.INT_TYPE, (Object)columnDesc.getType());
        columnDesc = schema.getColumnDescriptorAt(5);
        Assert.assertEquals((Object)"SPECIFIC_NAME", (Object)columnDesc.getName());
        Assert.assertEquals((Object)Type.STRING_TYPE, (Object)columnDesc.getType());
        client.closeOperation(opHandle);
        client.closeSession(sessionHandle);
    }

    @Test
    public void testGetInfo() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", Collections.emptyMap());
        Assert.assertNotNull((Object)sessionHandle);
        GetInfoValue value = client.getInfo(sessionHandle, GetInfoType.CLI_DBMS_NAME);
        System.out.println(value.getStringValue());
        value = client.getInfo(sessionHandle, GetInfoType.CLI_SERVER_NAME);
        System.out.println(value.getStringValue());
        value = client.getInfo(sessionHandle, GetInfoType.CLI_DBMS_VER);
        System.out.println(value.getStringValue());
        client.closeSession(sessionHandle);
    }

    @Test
    public void testExecuteStatement() throws Exception {
        HashMap confOverlay = new HashMap();
        SessionHandle sessionHandle = client.openSession("tom", "password", new HashMap());
        Assert.assertNotNull((Object)sessionHandle);
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        queryString = "CREATE TABLE TEST_EXEC(ID STRING)";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        queryString = "SELECT ID+1 FROM TEST_EXEC";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC";
        opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        client.closeSession(sessionHandle);
    }

    @Test
    public void testExecuteStatementAsync() throws Exception {
        HashMap<String, String> confOverlay = new HashMap<String, String>();
        String tableName = "TEST_EXEC_ASYNC";
        String columnDefinitions = "(ID STRING)";
        SessionHandle sessionHandle = this.setupTestData(tableName, columnDefinitions, confOverlay);
        Assert.assertNotNull((Object)sessionHandle);
        OperationState state = null;
        OperationStatus opStatus = null;
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeOperation(opHandle);
        long longPollingTimeout = HiveConf.getTimeVar((Configuration)new HiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        queryString = "SELECT NON_EXISTING_COLUMN FROM " + tableName;
        try {
            this.runQueryAsync(sessionHandle, queryString, confOverlay, OperationState.ERROR, longPollingTimeout);
        }
        catch (HiveSQLException e) {
            // empty catch block
        }
        queryString = "CREATE TABLE NON_EXISTING_TAB (ID STRING) location 'invalid://localhost:10000/a/b/c'";
        opStatus = this.runQueryAsync(sessionHandle, queryString, confOverlay, OperationState.ERROR, longPollingTimeout);
        Assert.assertEquals((Object)opStatus.getOperationException().getSQLState(), (Object)"08S01");
        Assert.assertEquals((long)opStatus.getOperationException().getErrorCode(), (long)1L);
        queryString = "SELECT ID+1 FROM " + tableName;
        this.runQueryAsync(sessionHandle, queryString, confOverlay, OperationState.FINISHED, longPollingTimeout);
        longPollingTimeout = 0L;
        queryString = "SELECT ID+1 FROM " + tableName;
        this.runQueryAsync(sessionHandle, queryString, confOverlay, OperationState.FINISHED, longPollingTimeout);
        longPollingTimeout = 500L;
        queryString = "SELECT ID+1 FROM " + tableName;
        this.runQueryAsync(sessionHandle, queryString, confOverlay, OperationState.FINISHED, longPollingTimeout);
        queryString = "SELECT ID+1 FROM " + tableName;
        opHandle = client.executeStatementAsync(sessionHandle, queryString, confOverlay);
        System.out.println("Cancelling " + opHandle);
        client.cancelOperation(opHandle);
        state = client.getOperationStatus(opHandle).getState();
        System.out.println(opHandle + " after cancelling, state= " + state);
        Assert.assertEquals((String)"Query should be cancelled", (Object)OperationState.CANCELED, (Object)state);
        queryString = "DROP TABLE " + tableName;
        client.executeStatement(sessionHandle, queryString, confOverlay);
        client.closeSession(sessionHandle);
    }

    private SessionHandle setupTestData(String tableName, String columnDefinitions, Map<String, String> confOverlay) throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", confOverlay);
        Assert.assertNotNull((Object)sessionHandle);
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        client.executeStatement(sessionHandle, queryString, confOverlay);
        queryString = "DROP TABLE IF EXISTS " + tableName;
        client.executeStatement(sessionHandle, queryString, confOverlay);
        queryString = "CREATE TABLE " + tableName + columnDefinitions;
        client.executeStatement(sessionHandle, queryString, confOverlay);
        return sessionHandle;
    }

    private OperationStatus runQueryAsync(SessionHandle sessionHandle, String queryString, Map<String, String> confOverlay, OperationState expectedState, long longPollingTimeout) throws HiveSQLException {
        long testIterationTimeout = System.currentTimeMillis() + 100000L;
        OperationStatus opStatus = null;
        OperationState state = null;
        confOverlay.put(HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT.varname, longPollingTimeout + "ms");
        OperationHandle opHandle = client.executeStatementAsync(sessionHandle, queryString, confOverlay);
        int count = 0;
        while (true) {
            if (System.currentTimeMillis() > testIterationTimeout) {
                System.out.println("Polling timed out");
                break;
            }
            long longPollingStart = System.currentTimeMillis();
            System.out.println("Long polling starts at: " + longPollingStart);
            opStatus = client.getOperationStatus(opHandle);
            state = opStatus.getState();
            long longPollingEnd = System.currentTimeMillis();
            System.out.println("Long polling ends at: " + longPollingEnd);
            System.out.println("Polling: " + opHandle + " count=" + ++count + " state=" + state);
            if (state == OperationState.CANCELED || state == OperationState.CLOSED || state == OperationState.FINISHED || state == OperationState.ERROR) break;
            long longPollingTimeDelta = longPollingEnd - longPollingStart;
            Assert.assertTrue(((double)longPollingTimeDelta - 0.9 * (double)longPollingTimeout > 0.0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)expectedState, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        return opStatus;
    }

    @Test
    public void testConfOverlay() throws Exception {
        SessionHandle sessionHandle = client.openSession("tom", "password", new HashMap());
        Assert.assertNotNull((Object)sessionHandle);
        String tabName = "TEST_CONF_EXEC";
        String tabNameVar = "tabNameVar";
        String setLockMgr = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(sessionHandle, setLockMgr, null);
        client.closeOperation(opHandle);
        String dropTable = "DROP TABLE IF EXISTS " + tabName;
        opHandle = client.executeStatement(sessionHandle, dropTable, null);
        client.closeOperation(opHandle);
        HashMap<String, String> confOverlay = new HashMap<String, String>();
        confOverlay.put(tabNameVar, tabName);
        String createTab = "CREATE TABLE ${hiveconf:" + tabNameVar + "} (id int)";
        opHandle = client.executeStatement(sessionHandle, createTab, confOverlay);
        Assert.assertNotNull((Object)opHandle);
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        String selectTab = "SELECT * FROM " + tabName;
        opHandle = client.executeStatement(sessionHandle, selectTab, null);
        Assert.assertNotNull((Object)opHandle);
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)client.getOperationStatus(opHandle).getState());
        client.closeOperation(opHandle);
        selectTab = "SELECT * FROM ${hiveconf:" + tabNameVar + "}";
        try {
            opHandle = client.executeStatement(sessionHandle, selectTab, null);
            Assert.fail((String)"Query should fail");
        }
        catch (HiveSQLException e) {
            // empty catch block
        }
        dropTable = "DROP TABLE IF EXISTS " + tabName;
        opHandle = client.executeStatement(sessionHandle, dropTable, null);
        client.closeOperation(opHandle);
        client.closeSession(sessionHandle);
    }
}

