/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hive.service.Service;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.hive.service.server.HiveServer2;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThriftCliServiceTestWithCookie {
    protected static int port;
    protected static String host;
    protected static HiveServer2 hiveServer2;
    protected static ThriftCLIServiceClient client;
    protected static HiveConf hiveConf;
    protected static String USERNAME;
    protected static String PASSWORD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        port = MetaStoreUtils.findFreePort();
        hiveServer2 = new HiveServer2();
        hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_AUTH_ENABLED, true);
        hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_MAX_AGE, 1L, TimeUnit.SECONDS);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_IS_SECURE, false);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE, "http");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH, "cliservice");
        Assert.assertNotNull((Object)port);
        Assert.assertNotNull((Object)hiveServer2);
        Assert.assertNotNull((Object)hiveConf);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, host);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT, port);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION, HiveAuthFactory.AuthTypes.NOSASL.toString());
        ThriftCliServiceTestWithCookie.startHiveServer2WithConf(hiveConf);
        client = ThriftCliServiceTestWithCookie.getServiceClientInternal();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ThriftCliServiceTestWithCookie.stopHiveServer2();
    }

    protected static void startHiveServer2WithConf(HiveConf hiveConf) throws Exception {
        hiveServer2.init(hiveConf);
        try {
            hiveServer2.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail();
        }
        Thread.sleep(2000L);
        System.out.println("HiveServer2 started on port " + port);
    }

    protected static void stopHiveServer2() throws Exception {
        if (hiveServer2 != null) {
            hiveServer2.stop();
        }
    }

    protected static ThriftCLIServiceClient getServiceClientInternal() {
        for (Service service : hiveServer2.getServices()) {
            if (service instanceof ThriftBinaryCLIService) {
                return new ThriftCLIServiceClient((TCLIService.Iface)((ThriftBinaryCLIService)service));
            }
            if (!(service instanceof ThriftHttpCLIService)) continue;
            return new ThriftCLIServiceClient((TCLIService.Iface)((ThriftHttpCLIService)service));
        }
        throw new IllegalStateException("HiveServer2 not running Thrift service");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOpenSession() throws Exception {
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, new HashMap());
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        client.closeSession(sessHandle);
    }

    @Test
    public void testGetFunctions() throws Exception {
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, new HashMap());
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        String catalogName = null;
        String schemaName = null;
        String functionName = "*";
        OperationHandle opHandle = client.getFunctions(sessHandle, catalogName, schemaName, functionName);
        Assert.assertNotNull((String)"Operation handle should not be null", (Object)opHandle);
        client.closeSession(sessHandle);
    }

    @Test
    public void testExecuteStatement() throws Exception {
        HashMap opConf = new HashMap();
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, opConf);
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        String queryString = "SET hive.lock.manager=org.apache.hadoop.hive.ql.lockmgr.EmbeddedLockManager";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC_THRIFT";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "CREATE TABLE TEST_EXEC_THRIFT(ID STRING)";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "SELECT ID+1 FROM TEST_EXEC_THRIFT";
        OperationHandle opHandle = client.executeStatement(sessHandle, queryString, opConf);
        Assert.assertNotNull((Object)opHandle);
        OperationStatus opStatus = client.getOperationStatus(opHandle);
        Assert.assertNotNull((Object)opStatus);
        OperationState state = opStatus.getState();
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)state);
        queryString = "DROP TABLE TEST_EXEC_THRIFT";
        client.executeStatement(sessHandle, queryString, opConf);
        client.closeSession(sessHandle);
    }

    static {
        host = "localhost";
        USERNAME = "anonymous";
        PASSWORD = "anonymous";
    }
}

