/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.security.sasl.AuthenticationException;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.LdapAuthenticationProviderImpl;

public class TestLdapAuthenticationProviderImpl
extends TestCase {
    private static HiveConf hiveConf;
    private static byte[] hiveConfBackup;

    public void setUp() throws Exception {
        hiveConf = new HiveConf();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        hiveConf.writeXml((OutputStream)baos);
        baos.close();
        hiveConfBackup = baos.toByteArray();
        hiveConf.set("hive.server2.authentication.ldap.url", "localhost");
        FileOutputStream fos = new FileOutputStream(new File(hiveConf.getHiveSiteLocation().toURI()));
        hiveConf.writeXml((OutputStream)fos);
        fos.close();
    }

    public void testLdapEmptyPassword() {
        LdapAuthenticationProviderImpl ldapImpl = new LdapAuthenticationProviderImpl();
        try {
            ldapImpl.Authenticate("user", "");
            TestLdapAuthenticationProviderImpl.assertFalse((boolean)true);
        }
        catch (AuthenticationException e) {
            TestLdapAuthenticationProviderImpl.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("a null or blank password has been provided"));
        }
    }

    public void tearDown() throws Exception {
        if (hiveConf != null && hiveConfBackup != null) {
            FileOutputStream fos = new FileOutputStream(new File(hiveConf.getHiveSiteLocation().toURI()));
            fos.write(hiveConfBackup);
            fos.close();
        }
    }
}

