/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.File;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOperationLoggingAPI {
    private static HiveConf hiveConf;
    private final String tableName = "testOperationLoggingAPI_table";
    private File dataFile;
    private ThriftCLIServiceClient client;
    private SessionHandle sessionHandle;
    private final String sql = "select * from testOperationLoggingAPI_table";
    private final String[] expectedLogs = new String[]{"Parsing command", "Parse Completed", "Starting Semantic Analysis", "Semantic Analysis Completed", "Starting command"};

    @BeforeClass
    public static void setUpBeforeClass() {
        hiveConf = new HiveConf();
        hiveConf.setBoolean(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_VERBOSE.varname, true);
    }

    @Before
    public void setUp() throws Exception {
        this.dataFile = new File(hiveConf.get("test.data.files"), "kv1.txt");
        EmbeddedThriftBinaryCLIService service = new EmbeddedThriftBinaryCLIService();
        service.init(hiveConf);
        this.client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        this.sessionHandle = this.setupSession();
    }

    @After
    public void tearDown() throws Exception {
        String queryString = "DROP TABLE testOperationLoggingAPI_table";
        this.client.executeStatement(this.sessionHandle, queryString, null);
        this.client.closeSession(this.sessionHandle);
    }

    @Test
    public void testFetchResultsOfLog() throws Exception {
        OperationHandle operationHandle = this.client.executeStatement(this.sessionHandle, "select * from testOperationLoggingAPI_table", null);
        RowSet rowSetLog = this.client.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 1000L, FetchType.LOG);
        this.verifyFetchedLog(rowSetLog);
    }

    @Test
    public void testFetchResultsOfLogAsync() throws Exception {
        OperationHandle operationHandle = this.client.executeStatementAsync(this.sessionHandle, "select * from testOperationLoggingAPI_table", null);
        boolean isQueryRunning = true;
        long pollTimeout = System.currentTimeMillis() + 100000L;
        OperationState state = null;
        RowSet rowSetAccumulated = null;
        StringBuilder logs = new StringBuilder();
        while (isQueryRunning && System.currentTimeMillis() <= pollTimeout) {
            OperationStatus opStatus = this.client.getOperationStatus(operationHandle);
            Assert.assertNotNull((Object)opStatus);
            state = opStatus.getState();
            rowSetAccumulated = this.client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 1000L, FetchType.LOG);
            for (Object[] row : rowSetAccumulated) {
                logs.append(row[0]);
            }
            if (state == OperationState.CANCELED || state == OperationState.CLOSED || state == OperationState.FINISHED || state == OperationState.ERROR) {
                isQueryRunning = false;
            }
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, state);
        this.verifyFetchedLog(logs.toString());
        RowSet rowSet = this.client.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 1000L, FetchType.LOG);
        this.verifyFetchedLog(rowSet);
    }

    @Test
    public void testFetchResultsOfLogWithOrientation() throws Exception {
        RowSet rowSetLogWithOrientation;
        OperationHandle operationHandle = this.client.executeStatement(this.sessionHandle, "select * from testOperationLoggingAPI_table", null);
        RowSet rowSetLog = this.client.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 1000L, FetchType.LOG);
        int expectedLogLength = rowSetLog.numRows();
        OperationHandle operationHandleWithOrientation = this.client.executeStatement(this.sessionHandle, "select * from testOperationLoggingAPI_table", null);
        int logLength = 0;
        int maxRows = this.calculateProperMaxRows(expectedLogLength);
        do {
            rowSetLogWithOrientation = this.client.fetchResults(operationHandleWithOrientation, FetchOrientation.FETCH_NEXT, (long)maxRows, FetchType.LOG);
            logLength += rowSetLogWithOrientation.numRows();
        } while (rowSetLogWithOrientation.numRows() == maxRows);
        Assert.assertEquals((long)expectedLogLength, (long)logLength);
        rowSetLogWithOrientation = this.client.fetchResults(operationHandleWithOrientation, FetchOrientation.FETCH_FIRST, 1000L, FetchType.LOG);
        this.verifyFetchedLog(rowSetLogWithOrientation);
    }

    @Test
    public void testFetchResultsOfLogCleanup() throws Exception {
        SessionHandle sessionHandleCleanup = this.setupSession();
        OperationHandle operationHandle = this.client.executeStatement(sessionHandleCleanup, "select * from testOperationLoggingAPI_table", null);
        RowSet rowSetLog = this.client.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 1000L, FetchType.LOG);
        this.verifyFetchedLog(rowSetLog);
        File sessionLogDir = new File(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION) + File.separator + sessionHandleCleanup.getHandleIdentifier());
        File operationLogFile = new File(sessionLogDir, operationHandle.getHandleIdentifier().toString());
        this.client.closeOperation(operationHandle);
        try {
            this.client.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 1000L, FetchType.LOG);
            Assert.fail((String)"Fetch should fail");
        }
        catch (HiveSQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid OperationHandle:"));
        }
        if (operationLogFile.exists()) {
            Assert.fail((String)"Operation log file should be deleted.");
        }
        this.client.closeSession(sessionHandleCleanup);
        if (sessionLogDir.exists()) {
            Assert.fail((String)"Session log dir should be deleted.");
        }
    }

    private SessionHandle setupSession() throws Exception {
        SessionHandle sessionHandle = this.client.openSession(null, null, null);
        String queryString = "SET hive.lock.manager=org.apache.hadoop.hive.ql.lockmgr.EmbeddedLockManager";
        this.client.executeStatement(sessionHandle, queryString, null);
        queryString = "DROP TABLE IF EXISTS testOperationLoggingAPI_table";
        this.client.executeStatement(sessionHandle, queryString, null);
        queryString = "create table testOperationLoggingAPI_table (key int, value string)";
        this.client.executeStatement(sessionHandle, queryString, null);
        queryString = "load data local inpath '" + this.dataFile + "' into table " + "testOperationLoggingAPI_table";
        this.client.executeStatement(sessionHandle, queryString, null);
        OperationHandle operationHandle = this.client.executeStatement(sessionHandle, "select * from testOperationLoggingAPI_table", null);
        RowSet rowSetResult = this.client.fetchResults(operationHandle);
        Assert.assertEquals((long)500L, (long)rowSetResult.numRows());
        Assert.assertEquals((Object)238, (Object)((Object[])rowSetResult.iterator().next())[0]);
        Assert.assertEquals((Object)"val_238", (Object)((Object[])rowSetResult.iterator().next())[1]);
        return sessionHandle;
    }

    private int calculateProperMaxRows(int len) {
        if (len < 10) {
            return 1;
        }
        if (len < 100) {
            return 10;
        }
        return 100;
    }

    private void verifyFetchedLog(RowSet rowSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object[] row : rowSet) {
            stringBuilder.append(row[0]);
        }
        String logs = stringBuilder.toString();
        this.verifyFetchedLog(logs);
    }

    private void verifyFetchedLog(String logs) {
        for (String log : this.expectedLogs) {
            Assert.assertTrue((String)("Checking for presence of " + log), (boolean)logs.contains(log));
        }
    }
}

