/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.MapRSecSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthFactory.class);
    private final HadoopThriftAuthBridge.Server saslServer;
    private final AuthTypes authType;
    private final TransTypes transportType;
    private final int saslMessageLimit;
    private final HiveConf conf;
    public static final String HS2_PROXY_USER = "hive.server2.proxy.user";
    public static final String HS2_CLIENT_TOKEN = "hiveserver2ClientToken";

    public HiveAuthFactory(HiveConf conf) throws TTransportException {
        this.conf = conf;
        this.saslMessageLimit = conf.getIntVar(HiveConf.ConfVars.HIVE_THRIFT_SASL_MESSAGE_LIMIT);
        String transTypeStr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        String authTypeStr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        this.transportType = TransTypes.valueOf(transTypeStr.toUpperCase());
        AuthTypes authTypes = this.authType = authTypeStr == null ? this.transportType.getDefaultAuthType() : AuthTypes.valueOf(authTypeStr.toUpperCase());
        if (this.transportType == TransTypes.BINARY && authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.name()) && ShimLoader.getHadoopShims().isSecureShimImpl()) {
            this.saslServer = ShimLoader.getHadoopThriftAuthBridge().createServer(conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
            try {
                this.saslServer.startDelegationTokenSecretManager((Configuration)conf, null, HadoopThriftAuthBridge.Server.ServerMode.HIVESERVER2);
            }
            catch (Exception e) {
                throw new TTransportException("Failed to start token manager", (Throwable)e);
            }
        } else {
            this.saslServer = this.transportType == TransTypes.BINARY && authTypeStr.equalsIgnoreCase(AuthTypes.MAPRSASL.name()) && ShimLoader.getHadoopShims().isSecureShimImpl() ? ShimLoader.getHadoopThriftAuthBridge().createServer(conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL)) : null;
        }
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws Exception {
        if (this.authType == AuthTypes.KERBEROS || this.authType == AuthTypes.MAPRSASL) {
            return this.saslServer.createTransportFactory(this.getSaslProperties(), this.saslMessageLimit);
        }
        if (this.authType == AuthTypes.NOSASL) {
            return new TTransportFactory();
        }
        return PlainSaslHelper.getPlainTransportFactory(this.authType.name(), this.saslMessageLimit);
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) {
        if (this.authType == AuthTypes.KERBEROS) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        if (this.authType == AuthTypes.MAPRSASL) {
            return MapRSecSaslHelper.getProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        return this.saslServer == null ? null : this.saslServer.getRemoteUser();
    }

    public String getIpAddress() {
        return this.saslServer != null ? this.saslServer.getRemoteAddress().toString() : null;
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 Kerberos principal or keytab is not correctly configured");
        }
        ShimLoader.getHadoopShims().loginUserFromKeytab(principal, keyTabFile);
    }

    public static UserGroupInformation loginFromSpnegoKeytabAndReturnUGI(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 SPNEGO principal or keytab is not correctly configured");
        }
        return ShimLoader.getHadoopShims().loginUserFromKeytabAndReturnUGI(principal, keyTabFile);
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout) {
        return new TSocket(host, port, loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        params.requireClientAuth(true);
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
    }

    public static TServerSocket getServerSocket(String hiveHost, int portNum, int socketTimeout, boolean keepAlive) throws TTransportException {
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        TServerSocket serverSocket = new TServerSocket(serverAddress, socketTimeout);
        if (keepAlive) {
            serverSocket = new TServerSocketKeepAlive(serverSocket.getServerSocket());
        }
        return serverSocket;
    }

    public static TServerSocket getServerSSLSocket(String hiveHost, int portNum, String keyStorePath, String keyStorePassWord, List<String> sslVersionBlacklist, int socketTimeout, boolean keepAlive) throws TTransportException, UnknownHostException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(keyStorePath, keyStorePassWord);
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        TServerSocket thriftServerSocket = TSSLTransportFactory.getServerSocket((int)portNum, (int)socketTimeout, (InetAddress)serverAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
        if (thriftServerSocket.getServerSocket() instanceof SSLServerSocket) {
            ArrayList<String> sslVersionBlacklistLocal = new ArrayList<String>();
            for (String sslVersion : sslVersionBlacklist) {
                sslVersionBlacklistLocal.add(sslVersion.trim().toLowerCase());
            }
            SSLServerSocket sslServerSocket = (SSLServerSocket)thriftServerSocket.getServerSocket();
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslServerSocket.getEnabledProtocols()) {
                if (sslVersionBlacklistLocal.contains(protocol.toLowerCase())) {
                    LOG.debug("Disabling SSL Protocol: " + protocol);
                    continue;
                }
                enabledProtocols.add(protocol);
            }
            sslServerSocket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            LOG.info("SSL Server Socket Enabled Protocols: " + Arrays.toString(sslServerSocket.getEnabledProtocols()));
        }
        if (keepAlive) {
            thriftServerSocket = new TServerSocketKeepAlive(thriftServerSocket.getServerSocket());
        }
        return thriftServerSocket;
    }

    public String getDelegationToken(String owner, String renewer) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            String tokenStr = this.saslServer.getDelegationTokenWithService(owner, renewer, HS2_CLIENT_TOKEN);
            if (tokenStr == null || tokenStr.isEmpty()) {
                throw new HiveSQLException("Received empty retrieving delegation token for user " + owner, "08S01");
            }
            return tokenStr;
        }
        catch (IOException e) {
            throw new HiveSQLException("Error retrieving delegation token for user " + owner, "08S01", e);
        }
        catch (InterruptedException e) {
            throw new HiveSQLException("delegation token retrieval interrupted", "08S01", e);
        }
    }

    public void cancelDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.saslServer.cancelDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error canceling delegation token " + delegationToken, "08S01", e);
        }
    }

    public void renewDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.saslServer.renewDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error renewing delegation token " + delegationToken, "08S01", e);
        }
    }

    public String getUserFromToken(String delegationToken) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.saslServer.getUserFromToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error extracting user from delegation token " + delegationToken, "08S01", e);
        }
    }

    public static void verifyProxyAccess(String realUser, String proxyUser, String ipAddress, HiveConf hiveConf) throws HiveSQLException {
        try {
            UserGroupInformation sessionUgi;
            if (ShimLoader.getHadoopShims().isSecurityEnabled()) {
                HadoopShims.KerberosNameShim kerbName = ShimLoader.getHadoopShims().getKerberosNameShim(realUser);
                String shortPrincipalName = kerbName.getServiceName();
                sessionUgi = ShimLoader.getHadoopShims().createProxyUser(shortPrincipalName);
            } else {
                sessionUgi = ShimLoader.getHadoopShims().createRemoteUser(realUser, null);
            }
            if (!proxyUser.equalsIgnoreCase(realUser)) {
                ShimLoader.getHadoopShims().authorizeProxyAccess(proxyUser, sessionUgi, ipAddress, (Configuration)hiveConf);
            }
        }
        catch (IOException e) {
            throw new HiveSQLException("Failed to validate proxy privilege of " + realUser + " for " + proxyUser, "08S01", e);
        }
    }

    static class TServerSocketKeepAlive
    extends TServerSocket {
        public TServerSocketKeepAlive(ServerSocket serverSocket) throws TTransportException {
            super(serverSocket);
        }

        protected TSocket acceptImpl() throws TTransportException {
            TSocket ts = super.acceptImpl();
            try {
                ts.getSocket().setKeepAlive(true);
            }
            catch (SocketException e) {
                throw new TTransportException((Throwable)e);
            }
            return ts;
        }
    }

    public static enum TransTypes {
        HTTP{

            @Override
            AuthTypes getDefaultAuthType() {
                return AuthTypes.NOSASL;
            }
        }
        ,
        BINARY{

            @Override
            AuthTypes getDefaultAuthType() {
                return AuthTypes.NONE;
            }
        };


        abstract AuthTypes getDefaultAuthType();
    }

    public static enum AuthTypes {
        NOSASL,
        NONE,
        LDAP,
        KERBEROS,
        CUSTOM,
        PAM,
        MAPRSASL;

    }
}

