/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.Session;

public abstract class Operation {
    private final Session parentSession;
    private OperationState state = OperationState.INITIALIZED;
    private final OperationHandle opHandle;
    private HiveConf configuration;
    public static final Log LOG = LogFactory.getLog((String)Operation.class.getName());
    public static final long DEFAULT_FETCH_MAX_ROWS = 100L;
    protected boolean hasResultSet;

    protected Operation(Session parentSession, OperationType opType) {
        this.parentSession = parentSession;
        this.opHandle = new OperationHandle(opType);
    }

    public void setConfiguration(HiveConf configuration) {
        this.configuration = new HiveConf(configuration);
    }

    public HiveConf getConfiguration() {
        return new HiveConf(this.configuration);
    }

    public Session getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationState getState() {
        return this.state;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    protected final OperationState setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        this.state = newState;
        return this.state;
    }

    protected final void assertState(OperationState state) throws HiveSQLException {
        if (this.state != state) {
            throw new HiveSQLException("Expected state " + (Object)((Object)state) + ", but found " + (Object)((Object)this.state));
        }
    }

    public boolean isRunning() {
        return OperationState.RUNNING.equals((Object)this.getState());
    }

    public boolean isFinished() {
        return OperationState.FINISHED.equals((Object)this.getState());
    }

    public boolean isCanceled() {
        return OperationState.CANCELED.equals((Object)this.getState());
    }

    public boolean isFailed() {
        return OperationState.ERROR.equals((Object)this.getState());
    }

    public abstract void run() throws HiveSQLException;

    public void cancel() throws HiveSQLException {
        this.setState(OperationState.CANCELED);
        throw new UnsupportedOperationException("SQLOperation.cancel()");
    }

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public RowSet getNextRowSet() throws HiveSQLException {
        return this.getNextRowSet(FetchOrientation.FETCH_NEXT, 100L);
    }
}

