/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.session.Session;

public class GetSchemasOperation
extends MetadataOperation {
    private final String catalogName;
    private final String schemaName;
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_SCHEMA", "Schema name.").addStringColumn("TABLE_CATALOG", "Catalog name.");
    private RowSet rowSet;

    protected GetSchemasOperation(Session parentSession, String catalogName, String schemaName) {
        super(parentSession, OperationType.GET_SCHEMAS);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        this.rowSet = new RowSet();
        try {
            IMetaStoreClient metastoreClient = this.getParentSession().getMetaStoreClient();
            String schemaPattern = this.convertSchemaPattern(this.schemaName);
            for (String dbName : metastoreClient.getDatabases(schemaPattern)) {
                this.rowSet.addRow(RESULT_SET_SCHEMA, new Object[]{dbName, ""});
            }
            this.setState(OperationState.FINISHED);
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        return this.rowSet.extractSubset((int)maxRows);
    }
}

